/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.GeometryUtil;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;
import org.osm2world.core.world.network.NetworkWaySegmentWorldObject;

public abstract class AbstractNetworkWaySegmentWorldObject
implements NetworkWaySegmentWorldObject,
WaySegmentWorldObject,
IntersectionTestObject,
WorldObjectWithOutline {
    public final MapWaySegment line;
    private VectorXZ startCutVector = null;
    private VectorXZ endCutVector = null;
    private VectorXZ startOffset = VectorXZ.NULL_VECTOR;
    private VectorXZ endOffset = VectorXZ.NULL_VECTOR;
    private List<VectorXYZ> leftOutline = null;
    private List<VectorXYZ> rightOutline = null;

    protected AbstractNetworkWaySegmentWorldObject(MapWaySegment mapWaySegment) {
        this.line = mapWaySegment;
    }

    @Override
    public MapElement getPrimaryMapElement() {
        return this.line;
    }

    @Override
    public void setStartCutVector(VectorXZ vectorXZ) {
        this.startCutVector = vectorXZ;
    }

    @Override
    public void setEndCutVector(VectorXZ vectorXZ) {
        this.endCutVector = vectorXZ;
    }

    @Override
    public VectorXZ getStartCutVector() {
        return this.startCutVector;
    }

    @Override
    public VectorXZ getEndCutVector() {
        return this.endCutVector;
    }

    public VectorXZ getCutVectorAt(MapNode mapNode) {
        if (mapNode == this.line.getStartNode()) {
            return this.getStartCutVector();
        }
        if (mapNode == this.line.getEndNode()) {
            return this.getEndCutVector();
        }
        throw new IllegalArgumentException("node is not part of the line");
    }

    @Override
    public void setStartOffset(VectorXZ vectorXZ) {
        this.startOffset = vectorXZ;
    }

    @Override
    public void setEndOffset(VectorXZ vectorXZ) {
        this.endOffset = vectorXZ;
    }

    protected VectorXZ getStartWithOffset() {
        return this.line.getStartNode().getPos().add(this.startOffset);
    }

    protected VectorXZ getEndWithOffset() {
        return this.line.getEndNode().getPos().add(this.endOffset);
    }

    public List<VectorXYZ> getCenterline() {
        WaySegmentElevationProfile waySegmentElevationProfile = this.line.getElevationProfile();
        if (this.startOffset == VectorXZ.NULL_VECTOR && this.endOffset == VectorXZ.NULL_VECTOR) {
            return waySegmentElevationProfile.getPointsWithEle();
        }
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        VectorXZ vectorXZ = this.getStartWithOffset();
        VectorXZ vectorXZ2 = this.getEndWithOffset();
        arrayList.add(vectorXZ.xyz(waySegmentElevationProfile.getEleAt(vectorXZ)));
        for (int i = 1; i < waySegmentElevationProfile.getPointsWithEle().size() - 1; ++i) {
            VectorXYZ vectorXYZ = (VectorXYZ)waySegmentElevationProfile.getPointsWithEle().get(i);
            VectorXZ vectorXZ3 = vectorXYZ.xz();
            if (!GeometryUtil.isBetween(vectorXZ3, vectorXZ, vectorXZ2) || !(VectorXZ.distanceSquared(vectorXZ3, vectorXZ) > 0.1) || !(VectorXZ.distanceSquared(vectorXZ3, vectorXZ2) > 0.1)) continue;
            arrayList.add(vectorXYZ);
        }
        arrayList.add(vectorXZ2.xyz(waySegmentElevationProfile.getEleAt(vectorXZ2)));
        return arrayList;
    }

    public List<VectorXYZ> getOutline(boolean bl) {
        if (bl) {
            if (this.rightOutline == null) {
                this.calculateOutlines();
            }
            return this.rightOutline;
        }
        if (this.leftOutline == null) {
            this.calculateOutlines();
        }
        return this.leftOutline;
    }

    @Override
    public PolygonXYZ getOutlinePolygon() {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        List<VectorXYZ> list = this.getOutline(false);
        List<VectorXYZ> list2 = this.getOutline(true);
        arrayList.addAll(list);
        list2 = new ArrayList<VectorXYZ>(list2);
        Collections.reverse(list2);
        arrayList.addAll(list2);
        arrayList.add((VectorXYZ)arrayList.get(0));
        return new PolygonXYZ(arrayList);
    }

    private void calculateOutlines() {
        if (this.startCutVector == null || this.endCutVector == null) {
            throw new IllegalStateException("cannot calculate outlines before cut vectors");
        }
        List<VectorXYZ> list = this.getCenterline();
        this.leftOutline = new ArrayList<VectorXYZ>(list.size());
        this.rightOutline = new ArrayList<VectorXYZ>(list.size());
        assert (list.size() >= 2);
        float f = this.getWidth() * 0.5f;
        VectorXYZ vectorXYZ = list.get(0);
        this.leftOutline.add(vectorXYZ.add(this.startCutVector.mult(-f)));
        this.rightOutline.add(vectorXYZ.add(this.startCutVector.mult(f)));
        for (int i = 1; i < list.size() - 1; ++i) {
            this.leftOutline.add(list.get(i).add(this.line.getRightNormal().mult(-f)));
            this.rightOutline.add(list.get(i).add(this.line.getRightNormal().mult(f)));
        }
        VectorXYZ vectorXYZ2 = list.get(list.size() - 1);
        this.leftOutline.add(vectorXYZ2.add(this.endCutVector.mult(-f)));
        this.rightOutline.add(vectorXYZ2.add(this.endCutVector.mult(f)));
    }

    @Override
    public VectorXZ getStartOffset() {
        return this.startOffset;
    }

    @Override
    public VectorXZ getEndOffset() {
        return this.endOffset;
    }

    @Override
    public VectorXZ getStartPosition() {
        return this.line.getStartNode().getPos().add(this.getStartOffset());
    }

    @Override
    public VectorXZ getEndPosition() {
        return this.line.getEndNode().getPos().add(this.getEndOffset());
    }

    @Override
    public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
        return new AxisAlignedBoundingBoxXZ(this.getOutlinePolygon().getVertices());
    }

    public String toString() {
        return "network way segment for " + this.line;
    }
}

