/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.TriangulationUtil;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;

public abstract class JunctionNodeWorldObject
implements NodeWorldObject,
IntersectionTestObject,
WorldObjectWithOutline {
    protected final MapNode node;
    protected boolean informationProvided = false;
    protected List<VectorXZ> cutVectors;
    protected List<VectorXZ> cutCenters;
    protected List<Float> widths;

    public void setInformation(List<VectorXZ> list, List<VectorXZ> list2, List<Float> list3) {
        this.informationProvided = true;
        this.cutCenters = list;
        this.cutVectors = list2;
        this.widths = list3;
    }

    public JunctionNodeWorldObject(MapNode mapNode) {
        this.node = mapNode;
    }

    @Override
    public MapElement getPrimaryMapElement() {
        return this.node;
    }

    public List<VectorXYZ> getOutline(int n, int n2) {
        this.checkInformationProvided();
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        List<MapSegment> list = this.node.getConnectedSegments();
        assert (n >= 0 && n < list.size());
        assert (n2 >= 0 && n2 < list.size());
        int n3 = n;
        while (n3 != n2) {
            VectorXZ vectorXZ;
            int n4;
            VectorXZ vectorXZ2 = this.getCutNode(n3, false);
            if (vectorXZ2 != null) {
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ2));
            }
            if ((n4 = n3 - 1) < 0) {
                n4 = list.size() - 1;
            }
            if ((vectorXZ = this.getCutNode(n4, true)) != null) {
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ));
            }
            n3 = n4;
        }
        return arrayList;
    }

    @Override
    public PolygonXYZ getOutlinePolygon() {
        PolygonXYZ polygonXYZ = this.getJunctionArea();
        if (polygonXYZ == null || !polygonXYZ.getXZPolygon().isSimple()) {
            return null;
        }
        if (polygonXYZ.getSimpleXZPolygon().isClockwise()) {
            return polygonXYZ.reverse();
        }
        return polygonXYZ;
    }

    @Override
    public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
        if (this.getOutlinePolygon() != null) {
            return new AxisAlignedBoundingBoxXZ(this.getOutlinePolygon().getVertices());
        }
        return new AxisAlignedBoundingBoxXZ(this.node.getPos().x, this.node.getPos().z, this.node.getPos().x, this.node.getPos().z);
    }

    @Override
    public double getClearingAbove(VectorXZ vectorXZ) {
        double d = 0.0;
        for (MapWaySegment mapWaySegment : this.node.getConnectedWaySegments()) {
            double d2;
            WaySegmentWorldObject waySegmentWorldObject = mapWaySegment.getPrimaryRepresentation();
            if (waySegmentWorldObject == null || !((d2 = waySegmentWorldObject.getClearingAbove(this.node.getPos())) > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public double getClearingBelow(VectorXZ vectorXZ) {
        double d = 0.0;
        for (MapWaySegment mapWaySegment : this.node.getConnectedWaySegments()) {
            double d2;
            WaySegmentWorldObject waySegmentWorldObject = mapWaySegment.getPrimaryRepresentation();
            if (waySegmentWorldObject == null || !((d2 = waySegmentWorldObject.getClearingBelow(this.node.getPos())) > d)) continue;
            d = d2;
        }
        return d;
    }

    public Collection<TriangleXYZ> getTriangulation() {
        List<TriangleXZ> list = TriangulationUtil.triangulate(this.getOutlinePolygon().getSimpleXZPolygon(), Collections.<SimplePolygonXZ>emptyList());
        ArrayList<TriangleXYZ> arrayList = new ArrayList<TriangleXYZ>(list.size());
        NodeElevationProfile nodeElevationProfile = this.node.getElevationProfile();
        for (TriangleXZ triangleXZ : list) {
            VectorXYZ vectorXYZ = nodeElevationProfile.getWithEle(triangleXZ.v1);
            VectorXYZ vectorXYZ2 = nodeElevationProfile.getWithEle(triangleXZ.v2);
            VectorXYZ vectorXYZ3 = nodeElevationProfile.getWithEle(triangleXZ.v3);
            if (triangleXZ.isClockwise()) {
                arrayList.add(new TriangleXYZ(vectorXYZ3, vectorXYZ2, vectorXYZ));
                continue;
            }
            arrayList.add(new TriangleXYZ(vectorXYZ, vectorXYZ2, vectorXYZ3));
        }
        return arrayList;
    }

    protected PolygonXYZ getJunctionArea() {
        this.checkInformationProvided();
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(this.cutCenters.size() * 2 + 1);
        for (int i = 0; i < this.cutCenters.size(); ++i) {
            if (this.cutCenters.get(i) == null) continue;
            VectorXZ vectorXZ = this.getCutNode(i, false);
            VectorXZ vectorXZ2 = this.getCutNode(i, true);
            if (vectorXZ != null) {
                arrayList.add(vectorXZ.xyz(this.node.getElevationProfile().getEleAt(vectorXZ)));
            }
            if (vectorXZ2 == null) continue;
            arrayList.add(vectorXZ2.xyz(this.node.getElevationProfile().getEleAt(vectorXZ2)));
        }
        if (arrayList.size() > 2) {
            arrayList.add((VectorXYZ)arrayList.get(0));
            return new PolygonXYZ(arrayList);
        }
        return null;
    }

    protected VectorXZ getCutNode(int n, boolean bl) {
        this.checkInformationProvided();
        VectorXZ vectorXZ = this.cutCenters.get(n);
        VectorXZ vectorXZ2 = this.cutVectors.get(n);
        Float f = this.widths.get(n);
        if (vectorXZ == null) {
            return null;
        }
        if (bl) {
            return vectorXZ.add(vectorXZ2.mult(f.floatValue() * 0.5f));
        }
        return vectorXZ.subtract(vectorXZ2.mult(f.floatValue() * 0.5f));
    }

    private void checkInformationProvided() throws IllegalStateException {
        if (!this.informationProvided) {
            throw new IllegalStateException("no junction information has been set for this representation");
        }
    }

    public String toString() {
        return "junction node WO for " + this.node;
    }
}

