/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.core.world.network;

import java.util.ArrayList;
import java.util.List;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapSegment;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.datastructures.IntersectionTestObject;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.WorldObjectWithOutline;
import org.osm2world.core.world.network.NetworkWaySegmentWorldObject;

public abstract class VisibleConnectorNodeWorldObject
implements NodeWorldObject,
IntersectionTestObject,
WorldObjectWithOutline {
    protected final MapNode node;
    protected boolean informationProvided;
    protected VectorXZ cutVector;
    protected VectorXZ startPos;
    protected VectorXZ endPos;
    protected float startWidth;
    protected float endWidth;

    public abstract float getLength();

    public void setInformation(VectorXZ vectorXZ, VectorXZ vectorXZ2, VectorXZ vectorXZ3, float f, float f2) {
        this.informationProvided = true;
        this.cutVector = vectorXZ;
        this.startPos = vectorXZ2;
        this.endPos = vectorXZ3;
        this.startWidth = f;
        this.endWidth = f2;
    }

    public VisibleConnectorNodeWorldObject(MapNode mapNode) {
        this.node = mapNode;
    }

    @Override
    public MapElement getPrimaryMapElement() {
        return this.node;
    }

    public List<VectorXYZ> getOutline(int n, int n2) {
        MapWaySegment mapWaySegment;
        this.checkInformationProvided();
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        List<MapSegment> list = this.node.getConnectedSegments();
        assert (n >= 0 && n < list.size());
        assert (n2 >= 0 && n2 < list.size());
        if (n == 1 && n2 == 0 || n == 0 && n2 == 1) {
            if (n == 0) {
                VectorXZ vectorXZ = this.startPos.add(this.cutVector.mult(this.startWidth));
                VectorXZ vectorXZ2 = this.endPos.add(this.cutVector.mult(this.endWidth));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ2));
            } else {
                VectorXZ vectorXZ = this.endPos.subtract(this.cutVector.mult(this.endWidth));
                VectorXZ vectorXZ3 = this.startPos.subtract(this.cutVector.mult(this.startWidth));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ3));
            }
        } else if (n == n2 && list.get(n) instanceof MapWaySegment && (mapWaySegment = (MapWaySegment)list.get(n)).getPrimaryRepresentation() instanceof NetworkWaySegmentWorldObject) {
            NetworkWaySegmentWorldObject networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)mapWaySegment.getPrimaryRepresentation());
            if (mapWaySegment.getEndNode() == this.node) {
                VectorXZ vectorXZ = this.node.getPos().add(networkWaySegmentWorldObject.getEndOffset()).add(networkWaySegmentWorldObject.getEndCutVector().mult(networkWaySegmentWorldObject.getWidth() / 2.0f));
                VectorXZ vectorXZ4 = this.node.getPos().add(networkWaySegmentWorldObject.getEndOffset()).subtract(networkWaySegmentWorldObject.getEndCutVector().mult(networkWaySegmentWorldObject.getWidth() / 2.0f));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ4));
            } else {
                VectorXZ vectorXZ = this.node.getPos().add(networkWaySegmentWorldObject.getStartOffset()).subtract(networkWaySegmentWorldObject.getStartCutVector().mult(networkWaySegmentWorldObject.getWidth() / 2.0f));
                VectorXZ vectorXZ5 = this.node.getPos().add(networkWaySegmentWorldObject.getStartOffset()).add(networkWaySegmentWorldObject.getStartCutVector().mult(networkWaySegmentWorldObject.getWidth() / 2.0f));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ));
                arrayList.add(this.node.getElevationProfile().getWithEle(vectorXZ5));
            }
        }
        return arrayList;
    }

    @Override
    public PolygonXYZ getOutlinePolygon() {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>(this.getOutline(0, 0));
        arrayList.addAll(this.getOutline(1, 1));
        arrayList.add((VectorXYZ)arrayList.get(0));
        return new PolygonXYZ(arrayList);
    }

    private void checkInformationProvided() throws IllegalStateException {
        if (!this.informationProvided) {
            throw new IllegalStateException("no connector information has been set for this representation.\nnode: " + this.node);
        }
    }

    @Override
    public AxisAlignedBoundingBoxXZ getAxisAlignedBoundingBoxXZ() {
        return new AxisAlignedBoundingBoxXZ(this.getOutlinePolygon().getVertices());
    }

    public String toString() {
        return "visible connector node WO for " + this.node;
    }
}

