/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ProgressDialog;
import org.osm2world.viewer.view.ViewerFrame;

public abstract class AbstractExportAction
extends AbstractAction
implements Observer {
    protected final ViewerFrame viewerFrame;
    protected final Data data;
    protected final MessageManager messageManager;
    protected final RenderOptions renderOptions;
    private File lastPath = null;

    protected AbstractExportAction(String string, ViewerFrame viewerFrame, Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super(string);
        this.viewerFrame = viewerFrame;
        this.messageManager = messageManager;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    protected boolean chooseDirectory() {
        return false;
    }

    protected abstract FileNameExtensionFilter getFileNameExtensionFilter();

    protected abstract void performExport(File var1);

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = this.askFile();
        if (file != null) {
            new ExportFileThread(file).start();
        }
    }

    private File askFile() {
        JFileChooser jFileChooser = new JFileChooser(this.lastPath);
        jFileChooser.setDialogTitle("Export file");
        if (this.chooseDirectory()) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileFilter(this.getFileNameExtensionFilter());
        }
        int n = jFileChooser.showSaveDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.lastPath = file.getParentFile();
            if (this.getFileNameExtensionFilter() != null && this.getFileNameExtensionFilter().getExtensions().length == 1) {
                String string = this.getFileNameExtensionFilter().getExtensions()[0];
                if (!file.getPath().endsWith("." + string)) {
                    file = new File(file.getPath() + "." + string);
                }
            }
            return file;
        }
        return null;
    }

    private class ExportFileThread
    extends Thread {
        private final File file;
        private ProgressDialog progressDialog;

        public ExportFileThread(File file) {
            super("ExportFileThread");
            this.file = file;
        }

        @Override
        public void run() {
            AbstractExportAction.this.viewerFrame.setCursor(Cursor.getPredefinedCursor(3));
            AbstractExportAction.this.viewerFrame.setEnabled(false);
            String string = "Export file";
            if (AbstractExportAction.this.getFileNameExtensionFilter() != null) {
                string = string + " of type " + AbstractExportAction.this.getFileNameExtensionFilter().getDescription();
            }
            this.progressDialog = new ProgressDialog(AbstractExportAction.this.viewerFrame, string);
            this.progressDialog.setProgress(null);
            this.progressDialog.setText("Writing file: " + this.file.getAbsolutePath());
            AbstractExportAction.this.performExport(this.file);
            this.progressDialog.dispose();
            AbstractExportAction.this.viewerFrame.setCursor(Cursor.getPredefinedCursor(0));
            AbstractExportAction.this.viewerFrame.setEnabled(true);
        }
    }
}

