/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.core.target.obj.ObjWriter;
import org.osm2world.viewer.control.actions.AbstractExportAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ExportObjAction
extends AbstractExportAction {
    public ExportObjAction(ViewerFrame viewerFrame, Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super("Export OBJ file", viewerFrame, data, messageManager, renderOptions);
        this.putValue("ShortDescription", "Writes a Wavefront .obj file");
        this.putValue("MnemonicKey", 79);
    }

    @Override
    protected FileNameExtensionFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter("Wavefront .obj files", "obj");
    }

    @Override
    protected void performExport(File file) throws HeadlessException {
        try {
            ObjWriter.writeObjFile(file, this.data.getConversionResults().getMapData(), this.data.getConversionResults().getEleData(), this.data.getConversionResults().getTerrain(), this.data.getConversionResults().getMapProjection(), null, this.renderOptions.projection);
            this.messageManager.addMessage("exported Wavefront .obj file " + file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.viewerFrame, iOException.toString(), "Could not export Wavefront .obj file", 0);
            iOException.printStackTrace();
        }
    }
}

