/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.core.target.obj.ObjWriter;
import org.osm2world.viewer.control.actions.AbstractExportAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ExportObjDirAction
extends AbstractExportAction {
    public ExportObjDirAction(ViewerFrame viewerFrame, Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super("Export OBJ directory", viewerFrame, data, messageManager, renderOptions);
        this.putValue("ShortDescription", "Writes several smaller Wavefront .obj files to a directory");
    }

    @Override
    protected boolean chooseDirectory() {
        return true;
    }

    @Override
    protected FileNameExtensionFilter getFileNameExtensionFilter() {
        return null;
    }

    @Override
    protected void performExport(File file) throws HeadlessException {
        try {
            String string = JOptionPane.showInputDialog(this.viewerFrame, "Graphics primitives per file", 10000);
            int n = Integer.parseInt(string);
            ObjWriter.writeObjFiles(file, this.data.getConversionResults().getMapData(), this.data.getConversionResults().getEleData(), this.data.getConversionResults().getTerrain(), this.data.getConversionResults().getMapProjection(), null, this.renderOptions.projection, n);
            this.messageManager.addMessage("exported Wavefront .obj file " + file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.viewerFrame, iOException.toString(), "Could not export Wavefront .obj file", 0);
            iOException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.viewerFrame, numberFormatException.toString(), "please enter a valid number of primitives per file", 0);
            numberFormatException.printStackTrace();
        }
    }
}

