/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.povray.POVRayWriter;
import org.osm2world.viewer.control.actions.AbstractExportAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ExportPOVRayAction
extends AbstractExportAction {
    public ExportPOVRayAction(ViewerFrame viewerFrame, Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super("Export POVRay file", viewerFrame, data, messageManager, renderOptions);
        this.putValue("ShortDescription", "Writes a source file for the POVRay raytracer");
        this.putValue("MnemonicKey", 80);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
    }

    @Override
    protected FileNameExtensionFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter("POVRay source files", "pov");
    }

    @Override
    protected void performExport(File file) throws HeadlessException {
        try {
            Camera camera = new Camera();
            camera.setLookAt(this.renderOptions.camera.getLookAt().x, this.renderOptions.camera.getLookAt().y, this.renderOptions.camera.getLookAt().z);
            camera.setPos(this.renderOptions.camera.getPos().x, this.renderOptions.camera.getPos().y, this.renderOptions.camera.getPos().z);
            POVRayWriter.writePOVInstructionFile(file, this.data.getConversionResults().getMapData(), this.data.getConversionResults().getEleData(), this.data.getConversionResults().getTerrain(), camera, this.renderOptions.projection);
            this.messageManager.addMessage("exported POVRay file " + file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.viewerFrame, iOException.toString(), "Could not export POVRay file", 0);
            iOException.printStackTrace();
        }
    }
}

