/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import com.sun.opengl.util.Screenshot;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.viewer.control.actions.AbstractExportAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ExportScreenshotAction
extends AbstractExportAction {
    public ExportScreenshotAction(ViewerFrame viewerFrame, Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super("Export Screenshot", viewerFrame, data, messageManager, renderOptions);
        this.putValue("ShortDescription", "Writes the current display content to an image file");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(154, 2));
    }

    @Override
    protected FileNameExtensionFilter getFileNameExtensionFilter() {
        return new FileNameExtensionFilter("PNG image files", "png");
    }

    @Override
    protected void performExport(File file) throws HeadlessException {
        try {
            this.viewerFrame.glCanvas.getContext().makeCurrent();
            Screenshot.writeToFile((File)file, (int)this.viewerFrame.glCanvas.getWidth(), (int)this.viewerFrame.glCanvas.getHeight());
            this.viewerFrame.glCanvas.getContext().release();
            this.messageManager.addMessage("exported PNG file " + file);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.viewerFrame, iOException.toString(), "Could not export PNG file", 0);
            iOException.printStackTrace();
        }
    }
}

