/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.math.InvalidGeometryException;
import org.osm2world.viewer.control.actions.ResetCameraAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ProgressDialog;
import org.osm2world.viewer.view.ViewerFrame;

public class OpenOSMAction
extends AbstractAction {
    ViewerFrame viewerFrame;
    Data data;
    RenderOptions renderOptions;
    private File lastPath = null;

    public OpenOSMAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Open OSM file");
        this.putValue("ShortDescription", "Opens a file with OpenStreetMap data");
        this.putValue("MnemonicKey", 79);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = this.askFile();
        if (file != null) {
            this.openOSMFile(file);
        }
    }

    public void openOSMFile(File file) {
        OpenOSMThread openOSMThread = new OpenOSMThread(file);
        openOSMThread.setUncaughtExceptionHandler(new ConversionExceptionHandler(this.viewerFrame));
        openOSMThread.start();
    }

    private File askFile() {
        JFileChooser jFileChooser = new JFileChooser(this.lastPath);
        jFileChooser.setDialogTitle("Open OSM file");
        jFileChooser.setFileFilter(new FileNameExtensionFilter("OpenStreetMap data files", "osm", "gz", "bz2", "pbf"));
        int n = jFileChooser.showOpenDialog(null);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.lastPath = file.getParentFile();
            return file;
        }
        return null;
    }

    private static class ConversionExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final ViewerFrame viewerFrame;

        public ConversionExceptionHandler(ViewerFrame viewerFrame) {
            this.viewerFrame = viewerFrame;
        }

        @Override
        public void uncaughtException(final Thread thread, final Throwable throwable) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showException(thread, throwable);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConversionExceptionHandler.this.showException(thread, throwable);
                    }
                });
            }
        }

        private void showException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
            String string = String.format("Unexpected problem on thread %s:\n%s\n\nOSM2World will be closed now.\n\nLocation:\n%s\n%s", thread.getName(), throwable.toString(), throwable.getStackTrace()[0], throwable.getStackTrace()[1]);
            JOptionPane.showMessageDialog(this.viewerFrame, string, "Error", 0);
            System.exit(1);
        }
    }

    private class OpenOSMThread
    extends Thread
    implements ConversionFacade.ProgressListener {
        private final File osmFile;
        private ProgressDialog progressDialog;

        public OpenOSMThread(File file) {
            super("OpenOSMThread");
            this.osmFile = file;
        }

        @Override
        public void run() {
            OpenOSMAction.this.viewerFrame.setCursor(Cursor.getPredefinedCursor(3));
            OpenOSMAction.this.viewerFrame.setEnabled(false);
            this.progressDialog = new ProgressDialog(OpenOSMAction.this.viewerFrame, "Open OSM File");
            try {
                OpenOSMAction.this.data.loadOSMFile(this.osmFile, OpenOSMAction.this.renderOptions.getEleCalculator(), this);
                new ResetCameraAction(OpenOSMAction.this.viewerFrame, OpenOSMAction.this.data, OpenOSMAction.this.renderOptions).actionPerformed(null);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(OpenOSMAction.this.viewerFrame, iOException.toString() + "\nCause: " + (iOException.getCause() == null ? "unknown" : iOException.getCause()), "Could not open OSM file", 0);
                iOException.printStackTrace();
            }
            catch (InvalidGeometryException invalidGeometryException) {
                JOptionPane.showMessageDialog(OpenOSMAction.this.viewerFrame, "The OSM data contains broken geometry.\nMake sure you are not using an extract with incomplete areas!\nIf you are e.g. using Osmosis, you need to use its completeWays=yes parameter.\nSee command line output for error details.", "Could not perform conversion", 0);
                invalidGeometryException.printStackTrace();
            }
            this.progressDialog.dispose();
            OpenOSMAction.this.viewerFrame.setCursor(Cursor.getPredefinedCursor(0));
            OpenOSMAction.this.viewerFrame.setEnabled(true);
        }

        @Override
        public void updatePhase(ConversionFacade.Phase phase) {
            switch (phase) {
                case MAP_DATA: {
                    this.progressDialog.setProgress(0);
                    this.progressDialog.setText("1/5: Organize information from .osm file...");
                    break;
                }
                case REPRESENTATION: {
                    this.progressDialog.setProgress(20);
                    this.progressDialog.setText("2/5: Choose visual representations for OSM objects...");
                    break;
                }
                case ELEVATION: {
                    this.progressDialog.setProgress(40);
                    this.progressDialog.setText("3/5: Guess elevations from available information...");
                    break;
                }
                case TERRAIN: {
                    this.progressDialog.setProgress(60);
                    this.progressDialog.setText("4/5: Generate terrain...");
                    break;
                }
                case FINISHED: {
                    this.progressDialog.setProgress(80);
                    this.progressDialog.setText("5/5: Represent objects by 3D primitives...");
                }
            }
        }
    }
}

