/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.target.common.rendering.OrthoTilesUtil;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class OrthoBoundsAction
extends AbstractAction
implements Observer {
    ViewerFrame viewerFrame;
    Data data;
    RenderOptions renderOptions;

    public OrthoBoundsAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Ortho bounds");
        this.putValue("ShortDescription", "Switch to orthographic view of the entire map data from south.");
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = this.data.getConversionResults().getMapData().getBoundary();
        this.renderOptions.camera = OrthoTilesUtil.cameraForBounds(axisAlignedBoundingBoxXZ, 30.0, OrthoTilesUtil.CardinalDirection.S);
        this.renderOptions.projection = OrthoTilesUtil.projectionForBounds(axisAlignedBoundingBoxXZ, 30.0, OrthoTilesUtil.CardinalDirection.S);
    }
}

