/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.target.common.rendering.OrthoTilesUtil;
import org.osm2world.core.target.common.rendering.TileNumber;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class OrthoTileAction
extends AbstractAction
implements Observer {
    ViewerFrame viewerFrame;
    Data data;
    RenderOptions renderOptions;

    public OrthoTileAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Ortho tile");
        this.putValue("ShortDescription", "Switch to orthographic view of a tile.");
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            int n = Integer.parseInt(JOptionPane.showInputDialog(this.viewerFrame, (Object)"zoom level"));
            int n2 = Integer.parseInt(JOptionPane.showInputDialog(this.viewerFrame, (Object)"tile x"));
            int n3 = Integer.parseInt(JOptionPane.showInputDialog(this.viewerFrame, (Object)"tile y"));
            int n4 = Integer.parseInt(JOptionPane.showInputDialog(this.viewerFrame, (Object)"view angle"));
            OrthoTilesUtil.CardinalDirection cardinalDirection = OrthoTilesUtil.CardinalDirection.valueOf(JOptionPane.showInputDialog(this.viewerFrame, (Object)"from cardinal direction"));
            AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = this.data.getConversionResults().getMapData().getBoundary();
            this.renderOptions.camera = OrthoTilesUtil.cameraForTile(this.data.getConversionResults().getMapProjection(), new TileNumber(n, n2, n3), n4, cardinalDirection);
            this.renderOptions.projection = OrthoTilesUtil.projectionForTile(this.data.getConversionResults().getMapProjection(), new TileNumber(n, n2, n3), n4, cardinalDirection);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this.viewerFrame, "invalid input");
        }
    }
}

