/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.osm2world.viewer.control.actions.OpenOSMAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ReloadOSMAction
extends AbstractAction
implements Observer {
    private final ViewerFrame viewerFrame;
    private final Data data;
    private final RenderOptions renderOptions;

    public ReloadOSMAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Reload OSM file");
        this.putValue("ShortDescription", "Reloads the most recently opened OSM file");
        this.putValue("MnemonicKey", 82);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 2));
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        new OpenOSMAction(this.viewerFrame, this.data, this.renderOptions).openOSMFile(this.data.getOsmFile());
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getOsmFile() != null);
    }
}

