/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.Defaults;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ResetCameraAction
extends AbstractAction
implements Observer {
    ViewerFrame viewerFrame;
    Data data;
    RenderOptions renderOptions;

    public ResetCameraAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Reset Camera");
        this.putValue("ShortDescription", "Use this if you have messed up the camera");
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MapData mapData = this.data.getConversionResults().getMapData();
        VectorXZ vectorXZ = mapData.getCenter();
        this.renderOptions.camera = new Camera();
        this.renderOptions.camera.setLookAt(vectorXZ.x, 0.0, vectorXZ.z);
        this.renderOptions.camera.setPos(vectorXZ.x, 1000.0, vectorXZ.z - 1000.0);
        this.renderOptions.projection = Defaults.PERSPECTIVE_PROJECTION;
    }
}

