/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.osm2world.core.map_data.creation.MapProjection;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class SetCameraToCoordinateAction
extends AbstractAction
implements Observer {
    ViewerFrame viewerFrame;
    Data data;
    RenderOptions renderOptions;

    public SetCameraToCoordinateAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Set camera to coordinate");
        this.putValue("ShortDescription", "Precisely position the camera");
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        double d = Double.parseDouble(JOptionPane.showInputDialog(this.viewerFrame, (Object)"lat"));
        double d2 = Double.parseDouble(JOptionPane.showInputDialog(this.viewerFrame, (Object)"lon"));
        double d3 = Double.parseDouble(JOptionPane.showInputDialog(this.viewerFrame, (Object)"height"));
        MapProjection mapProjection = this.data.getConversionResults().getMapProjection();
        VectorXZ vectorXZ = mapProjection.calcPos(d, d2);
        VectorXYZ vectorXYZ = vectorXZ.xyz(d3);
        this.renderOptions.camera.move(vectorXYZ.subtract(this.renderOptions.camera.getPos()));
    }
}

