/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.statistics.StatisticsTarget;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.view.StatisticsDialog;
import org.osm2world.viewer.view.ViewerFrame;

public class StatisticsAction
extends AbstractAction
implements Observer {
    private final ViewerFrame viewerFrame;
    private final Data data;

    public StatisticsAction(ViewerFrame viewerFrame, Data data) {
        super("Statistics");
        this.putValue("ShortDescription", "Shows statistics for the current scene");
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.setEnabled(false);
        data.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.setEnabled(this.data.getConversionResults() != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ConversionFacade.Results results = this.data.getConversionResults();
        StatisticsTarget statisticsTarget = new StatisticsTarget();
        TargetUtil.renderWorldObjects(statisticsTarget, results.getMapData());
        TargetUtil.renderObject(statisticsTarget, results.getTerrain());
        new StatisticsDialog(this.viewerFrame, statisticsTarget).setVisible(true);
    }
}

