/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;
import org.osm2world.viewer.view.debug.DebugView;

public class ToggleDebugViewAction
extends AbstractAction
implements Observer {
    private final DebugView debugView;
    private final ViewerFrame viewerFrame;
    private final Data data;
    private final RenderOptions renderOptions;
    private boolean enabled = false;

    public ToggleDebugViewAction(DebugView debugView, int n, boolean bl, ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super(debugView.getClass().getSimpleName());
        this.putValue("ShortDescription", debugView.getDescription());
        this.putValue("MnemonicKey", n);
        this.putValue("SwingSelectedKey", bl);
        this.debugView = debugView;
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
        this.enabled = bl;
        if (bl) {
            renderOptions.activeDebugViews.add(debugView);
        }
        data.addObserver(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.enabled) {
            this.renderOptions.activeDebugViews.remove(this.debugView);
        } else {
            this.renderOptions.activeDebugViews.add(this.debugView);
        }
        this.enabled = !this.enabled;
        this.putValue("SwingSelectedKey", this.enabled);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.debugView.setConversionResults(this.data.getConversionResults());
        this.debugView.setPrimitiveBuffers(this.data.getGridPrimitiveBuffer(), this.data.getTerrainPrimitiveBuffer());
    }
}

