/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.Defaults;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class ToggleOrthographicProjectionAction
extends AbstractAction {
    private final ViewerFrame viewerFrame;
    private final Data data;
    private final RenderOptions renderOptions;

    public ToggleOrthographicProjectionAction(ViewerFrame viewerFrame, Data data, RenderOptions renderOptions) {
        super("Orthographic projection");
        this.putValue("ShortDescription", "Switches between orthographic and perspective projection");
        this.putValue("MnemonicKey", 67);
        this.putValue("SwingSelectedKey", renderOptions.projection.isOrthographic());
        this.viewerFrame = viewerFrame;
        this.data = data;
        this.renderOptions = renderOptions;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.renderOptions.projection = this.renderOptions.projection.isOrthographic() ? Defaults.PERSPECTIVE_PROJECTION : Defaults.ORTHOGRAPHIC_PROJECTION;
        this.putValue("SwingSelectedKey", this.renderOptions.projection.isOrthographic());
    }
}

