/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.control.navigation;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.event.MouseInputListener;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.ViewerFrame;

public class DefaultNavigation
extends MouseAdapter
implements KeyListener,
MouseInputListener {
    private final RenderOptions renderOptions;
    private final ViewerFrame viewerFrame;
    private boolean translationDrag = false;
    private boolean rotationDrag = false;
    private Point previousMousePoint;
    private final Set<Integer> pressedKeys = new HashSet<Integer>();
    private final TimerTask KEYBOARD_TASK = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Camera camera = ((DefaultNavigation)DefaultNavigation.this).renderOptions.camera;
            if (camera != null) {
                Set set = DefaultNavigation.this.pressedKeys;
                synchronized (set) {
                    Iterator iterator = DefaultNavigation.this.pressedKeys.iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        switch (n) {
                            case 87: {
                                camera.moveForward(1.0);
                                break;
                            }
                            case 83: {
                                camera.moveForward(-1.0);
                                break;
                            }
                            case 65: {
                                camera.moveRight(1.0);
                                break;
                            }
                            case 68: {
                                camera.moveRight(-1.0);
                                break;
                            }
                            case 38: {
                                camera.move(0.0, 0.5, 0.0);
                                break;
                            }
                            case 40: {
                                camera.move(0.0, -0.5, 0.0);
                                break;
                            }
                            case 39: {
                                camera.rotateY(0.031415926535897934);
                                break;
                            }
                            case 37: {
                                camera.rotateY(-0.031415926535897934);
                                break;
                            }
                            case 521: {
                                DefaultNavigation.this.zoom(true, 0.5);
                                break;
                            }
                            case 45: {
                                DefaultNavigation.this.zoom(false, 0.5);
                            }
                        }
                    }
                }
            }
        }
    };

    public DefaultNavigation(ViewerFrame viewerFrame, RenderOptions renderOptions) {
        this.viewerFrame = viewerFrame;
        this.renderOptions = renderOptions;
        Timer timer = new Timer("KeyboardNavigation");
        timer.scheduleAtFixedRate(this.KEYBOARD_TASK, 0L, 20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Set<Integer> set = this.pressedKeys;
        synchronized (set) {
            this.pressedKeys.add(keyEvent.getKeyCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Set<Integer> set = this.pressedKeys;
        synchronized (set) {
            this.pressedKeys.remove(keyEvent.getKeyCode());
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        float f = point.x - this.previousMousePoint.x;
        float f2 = point.y - this.previousMousePoint.y;
        Camera camera = this.renderOptions.camera;
        if (camera != null) {
            if (this.translationDrag) {
                camera.moveForward(f2);
                camera.moveRight(f);
            } else if (this.rotationDrag) {
                camera.rotateY(f / 100.0f);
                VectorXYZ vectorXYZ = camera.getLookAt().subtract(camera.getPos());
                if (vectorXYZ.length() > (double)0.1f) {
                    VectorXZ vectorXZ = vectorXYZ.xz().mult(-f2 * 0.02f);
                    VectorXYZ vectorXYZ2 = camera.getLookAt().add(vectorXZ);
                    camera.setLookAt(vectorXYZ2);
                }
            }
        }
        this.previousMousePoint = point;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.viewerFrame.setCursor(new Cursor(13));
            this.translationDrag = true;
        } else {
            this.viewerFrame.setCursor(new Cursor(13));
            this.rotationDrag = true;
        }
        this.previousMousePoint = mouseEvent.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.viewerFrame.setCursor(new Cursor(0));
        this.translationDrag = false;
        this.rotationDrag = false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.zoom(mouseWheelEvent.getWheelRotation() < 0, 1.0);
    }

    private void zoom(boolean bl, double d) {
        Camera camera = this.renderOptions.camera;
        if (camera != null) {
            VectorXYZ vectorXYZ = camera.getLookAt().subtract(camera.getPos());
            VectorXYZ vectorXYZ2 = vectorXYZ.mult(d * (double)(bl ? 0.2f : -0.25f));
            VectorXYZ vectorXYZ3 = camera.getPos().add(vectorXYZ2);
            camera.setPos(vectorXYZ3);
        }
    }
}

