/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.model;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Observable;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.target.Renderable;
import org.osm2world.core.target.TargetUtil;
import org.osm2world.core.target.primitivebuffer.PrimitiveBuffer;
import org.osm2world.core.util.FaultTolerantIterationUtil;

public class Data
extends Observable {
    private Configuration config = new BaseConfiguration();
    private File osmFile = null;
    private ConversionFacade.Results conversionResults = null;
    private PrimitiveBuffer gridPrimitiveBuffer = null;
    private PrimitiveBuffer terrainPrimitiveBuffer = null;

    public void setConfig(Configuration configuration) {
        this.config = configuration;
    }

    public void loadOSMFile(File file, ElevationCalculator elevationCalculator, ConversionFacade.ProgressListener progressListener) throws IOException {
        try {
            this.osmFile = file;
            ConversionFacade conversionFacade = new ConversionFacade();
            conversionFacade.setElevationCalculator(elevationCalculator);
            conversionFacade.addProgressListener(progressListener);
            this.conversionResults = conversionFacade.createRepresentations(file, null, this.config, null);
            this.gridPrimitiveBuffer = Data.createPrimitiveBuffer(this.conversionResults, true, false);
            this.terrainPrimitiveBuffer = Data.createPrimitiveBuffer(this.conversionResults, false, true);
        }
        catch (IOException iOException) {
            file = null;
            this.conversionResults = null;
            this.gridPrimitiveBuffer = null;
            this.terrainPrimitiveBuffer = null;
            throw iOException;
        }
        this.setChanged();
        this.notifyObservers();
    }

    private static PrimitiveBuffer createPrimitiveBuffer(ConversionFacade.Results results, boolean bl, boolean bl2) {
        final PrimitiveBuffer primitiveBuffer = new PrimitiveBuffer();
        Collection<Renderable> collection = results.getRenderables(Renderable.class, bl, bl2);
        FaultTolerantIterationUtil.iterate(collection, new FaultTolerantIterationUtil.Operation<Renderable>(){

            @Override
            public void perform(Renderable renderable) {
                TargetUtil.renderObject(primitiveBuffer, renderable);
            }
        });
        return primitiveBuffer;
    }

    public File getOsmFile() {
        return this.osmFile;
    }

    public ConversionFacade.Results getConversionResults() {
        return this.conversionResults;
    }

    public PrimitiveBuffer getGridPrimitiveBuffer() {
        return this.gridPrimitiveBuffer;
    }

    public PrimitiveBuffer getTerrainPrimitiveBuffer() {
        return this.terrainPrimitiveBuffer;
    }
}

