/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.material.Materials;
import org.osm2world.core.target.statistics.StatisticsTarget;

public class StatisticsDialog
extends JDialog {
    private static final Map<StatisticsTarget.Stat, String> statNames = new HashMap<StatisticsTarget.Stat, String>();
    private static final Comparator<?> LONG_COMPARATOR;

    public StatisticsDialog(JFrame jFrame, StatisticsTarget statisticsTarget) {
        super((Frame)jFrame, "Statistics");
        Object object;
        ArrayList<Material> arrayList = new ArrayList<Material>(statisticsTarget.getKnownMaterials());
        ArrayList arrayList2 = new ArrayList(statisticsTarget.getKnownRenderableClasses());
        int n = StatisticsTarget.Stat.values().length + 1;
        int n2 = arrayList.size();
        int n3 = arrayList2.size();
        String[] stringArray = new String[n];
        Object[][] objectArray = new Object[n2 + 1][n];
        Object[][] objectArray2 = new Object[n3 + 1][n];
        Comparator[] comparatorArray = new Comparator[n];
        stringArray[0] = "name";
        objectArray[n2][0] = "TOTAL";
        objectArray2[n3][0] = "TOTAL";
        comparatorArray[0] = null;
        for (int i = 0; i < n; ++i) {
            int n4;
            Object object2 = object = i == 0 ? null : StatisticsTarget.Stat.values()[i - 1];
            if (i != 0) {
                stringArray[i] = statNames.get(object);
                comparatorArray[i] = LONG_COMPARATOR;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                if (i == 0) {
                    String string = Materials.getUniqueName((Material)arrayList.get(n4));
                    if (string == null) {
                        string = ((Material)arrayList.get(n4)).toString();
                    }
                    objectArray[n4][0] = string;
                    continue;
                }
                objectArray[n4][i] = statisticsTarget.getCountForMaterial((Material)arrayList.get(n4), (StatisticsTarget.Stat)((Object)object));
            }
            for (n4 = 0; n4 < n3; ++n4) {
                if (i == 0) {
                    objectArray2[n4][0] = ((Class)arrayList2.get(n4)).getSimpleName();
                    continue;
                }
                objectArray2[n4][i] = statisticsTarget.getCountForClass((Class)arrayList2.get(n4), (StatisticsTarget.Stat)((Object)object));
            }
            if (i == 0) continue;
            objectArray[n2][i] = statisticsTarget.getGlobalCount((StatisticsTarget.Stat)((Object)object));
            objectArray2[n3][i] = statisticsTarget.getGlobalCount((StatisticsTarget.Stat)((Object)object));
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.add(jTabbedPane);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        ((Container)object).add(new JLabel("object types: " + arrayList2.size()));
        ((Container)object).add(new JLabel("materials: " + arrayList.size()));
        for (StatisticsTarget.Stat stat : StatisticsTarget.Stat.values()) {
            ((Container)object).add(new JLabel(statNames.get((Object)stat) + ": " + statisticsTarget.getGlobalCount(stat)));
        }
        jTabbedPane.addTab("Global", null, (Component)object, "Global statistics");
        jTabbedPane.setMnemonicAt(0, 71);
        object = StatisticsDialog.createTableComponent(stringArray, objectArray, comparatorArray);
        jTabbedPane.addTab("Materials", null, (Component)object, "Statistics per material");
        jTabbedPane.setMnemonicAt(1, 77);
        object = StatisticsDialog.createTableComponent(stringArray, objectArray2, comparatorArray);
        jTabbedPane.addTab("Classes", null, (Component)object, "Statistics per WorldObject class");
        jTabbedPane.setMnemonicAt(2, 67);
        this.setSize(800, 500);
    }

    private static JComponent createTableComponent(String[] stringArray, Object[][] objectArray, Comparator<?>[] comparatorArray) {
        JTable jTable = new JTable(objectArray, stringArray);
        jTable.setFillsViewportHeight(true);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(jTable.getModel());
        for (int i = 0; i < stringArray.length; ++i) {
            tableRowSorter.setComparator(i, comparatorArray[i]);
        }
        jTable.setRowSorter(tableRowSorter);
        return new JScrollPane(jTable);
    }

    static {
        statNames.put(StatisticsTarget.Stat.OBJECT_COUNT, "objects");
        statNames.put(StatisticsTarget.Stat.PRIMITIVE_COUNT, "primitives");
        statNames.put(StatisticsTarget.Stat.TOTAL_TRIANGLE_COUNT, "triangles");
        statNames.put(StatisticsTarget.Stat.TRIANGLES_COUNT, "t. groups");
        statNames.put(StatisticsTarget.Stat.TRIANGLE_STRIP_COUNT, "t. strips");
        statNames.put(StatisticsTarget.Stat.TRIANGLE_FAN_COUNT, "t. fans");
        statNames.put(StatisticsTarget.Stat.CONVEX_POLYGON_COUNT, "polygons");
        LONG_COMPARATOR = new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                return ((Long)object).compareTo((Long)object2);
            }
        };
    }
}

