/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRadioButtonMenuItem;
import org.apache.commons.configuration.Configuration;
import org.osm2world.core.map_elevation.creation.EleTagElevationCalculator;
import org.osm2world.core.map_elevation.creation.ElevationCalculator;
import org.osm2world.core.map_elevation.creation.ForceElevationCalculator;
import org.osm2world.core.map_elevation.creation.LevelTagElevationCalculator;
import org.osm2world.core.map_elevation.creation.ZeroElevationCalculator;
import org.osm2world.viewer.control.actions.AboutAction;
import org.osm2world.viewer.control.actions.ExitAction;
import org.osm2world.viewer.control.actions.ExportObjAction;
import org.osm2world.viewer.control.actions.ExportObjDirAction;
import org.osm2world.viewer.control.actions.ExportPOVRayAction;
import org.osm2world.viewer.control.actions.ExportScreenshotAction;
import org.osm2world.viewer.control.actions.HelpControlsAction;
import org.osm2world.viewer.control.actions.OpenOSMAction;
import org.osm2world.viewer.control.actions.OrthoBoundsAction;
import org.osm2world.viewer.control.actions.OrthoTileAction;
import org.osm2world.viewer.control.actions.ReloadOSMAction;
import org.osm2world.viewer.control.actions.ResetCameraAction;
import org.osm2world.viewer.control.actions.SetCameraToCoordinateAction;
import org.osm2world.viewer.control.actions.SetElevationCalculatorAction;
import org.osm2world.viewer.control.actions.StatisticsAction;
import org.osm2world.viewer.control.actions.ToggleBackfaceCullingAction;
import org.osm2world.viewer.control.actions.ToggleDebugViewAction;
import org.osm2world.viewer.control.actions.ToggleOrthographicProjectionAction;
import org.osm2world.viewer.control.actions.ToggleWireframeAction;
import org.osm2world.viewer.control.navigation.DefaultNavigation;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.FileDrop;
import org.osm2world.viewer.view.ViewerGLCanvas;
import org.osm2world.viewer.view.debug.ClearingDebugView;
import org.osm2world.viewer.view.debug.EleDebugView;
import org.osm2world.viewer.view.debug.HelpView;
import org.osm2world.viewer.view.debug.MapDataBoundsDebugView;
import org.osm2world.viewer.view.debug.MapDataDebugView;
import org.osm2world.viewer.view.debug.MapDataElevationDebugView;
import org.osm2world.viewer.view.debug.NetworkDebugView;
import org.osm2world.viewer.view.debug.OrthoBoundsDebugView;
import org.osm2world.viewer.view.debug.QuadtreeDebugView;
import org.osm2world.viewer.view.debug.RoofDataDebugView;
import org.osm2world.viewer.view.debug.TerrainAABBDebugView;
import org.osm2world.viewer.view.debug.TerrainBoundaryAABBDebugView;
import org.osm2world.viewer.view.debug.TerrainBoundaryDebugView;
import org.osm2world.viewer.view.debug.TerrainCellLabelsView;
import org.osm2world.viewer.view.debug.TerrainElevationGridDebugView;
import org.osm2world.viewer.view.debug.TerrainNormalsDebugView;
import org.osm2world.viewer.view.debug.TerrainOutlineDebugView;
import org.osm2world.viewer.view.debug.TerrainView;
import org.osm2world.viewer.view.debug.TriangulationDebugView;
import org.osm2world.viewer.view.debug.WorldObjectNormalsDebugView;
import org.osm2world.viewer.view.debug.WorldObjectView;

public class ViewerFrame
extends JFrame {
    public final ViewerGLCanvas glCanvas;
    private final Data data;
    private final RenderOptions renderOptions;
    private final MessageManager messageManager;

    public ViewerFrame(final Data data, MessageManager messageManager, final RenderOptions renderOptions, Configuration configuration) {
        super("OSM2World Viewer");
        this.data = data;
        this.renderOptions = renderOptions;
        this.messageManager = messageManager;
        data.setConfig(configuration);
        this.createMenuBar();
        this.glCanvas = new ViewerGLCanvas(data, messageManager, renderOptions);
        this.add((Component)((Object)this.glCanvas), "Center");
        new FileDrop((Component)((Object)this.glCanvas), new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] fileArray) {
                if (fileArray.length >= 1) {
                    new OpenOSMAction(ViewerFrame.this, data, renderOptions).openOSMFile(fileArray[0]);
                }
            }
        });
        DefaultNavigation defaultNavigation = new DefaultNavigation(this, renderOptions);
        this.glCanvas.addMouseListener(defaultNavigation);
        this.glCanvas.addMouseMotionListener(defaultNavigation);
        this.glCanvas.addMouseWheelListener(defaultNavigation);
        this.glCanvas.addKeyListener(defaultNavigation);
        new ToggleDebugViewAction(new HelpView(), -1, true, this, data, renderOptions);
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(new OpenOSMAction(this, this.data, this.renderOptions));
        jMenu.add(new ReloadOSMAction(this, this.data, this.renderOptions));
        jMenu.add(new ExportObjAction(this, this.data, this.messageManager, this.renderOptions));
        jMenu.add(new ExportObjDirAction(this, this.data, this.messageManager, this.renderOptions));
        jMenu.add(new ExportPOVRayAction(this, this.data, this.messageManager, this.renderOptions));
        jMenu.add(new ExportScreenshotAction(this, this.data, this.messageManager, this.renderOptions));
        jMenu.add(new StatisticsAction(this, this.data));
        jMenu.add(new ExitAction());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("View");
        jMenu.setMnemonic(86);
        jMenu.add(new JCheckBoxMenuItem(new ToggleWireframeAction(this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleBackfaceCullingAction(this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new WorldObjectView(), 87, true, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainView(), 84, true, this, this.data, this.renderOptions)));
        jMenu.addSeparator();
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainBoundaryAABBDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainAABBDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new ClearingDebugView(), 76, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new MapDataDebugView(), 71, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new MapDataElevationDebugView(), 69, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new RoofDataDebugView(), 82, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new NetworkDebugView(), 88, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new QuadtreeDebugView(), 81, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainCellLabelsView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainBoundaryDebugView(), 66, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainOutlineDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainNormalsDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new WorldObjectNormalsDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TriangulationDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new MapDataBoundsDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new OrthoBoundsDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new TerrainElevationGridDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenu.add(new JCheckBoxMenuItem(new ToggleDebugViewAction(new EleDebugView(), -1, false, this, this.data, this.renderOptions)));
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Camera");
        jMenu.setMnemonic(67);
        jMenu.add(new ResetCameraAction(this, this.data, this.renderOptions));
        jMenu.add(new SetCameraToCoordinateAction(this, this.data, this.renderOptions));
        jMenu.add(new OrthoTileAction(this, this.data, this.renderOptions));
        jMenu.add(new OrthoBoundsAction(this, this.data, this.renderOptions));
        jMenu.add(new JCheckBoxMenuItem(new ToggleOrthographicProjectionAction(this, this.data, this.renderOptions)));
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Options");
        JMenu jMenu2 = new JMenu("ElevationCalculator");
        jMenu.add(jMenu2);
        jMenu.setMnemonic(79);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (ElevationCalculator elevationCalculator : Arrays.asList(new ZeroElevationCalculator(), new ForceElevationCalculator(), new EleTagElevationCalculator(), new LevelTagElevationCalculator())) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new SetElevationCalculatorAction(elevationCalculator, this, this.data, this.renderOptions));
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu2.add(jRadioButtonMenuItem);
        }
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        jMenu.add(new HelpControlsAction());
        jMenu.add(new AboutAction());
        jMenu.setMnemonic(72);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }
}

