/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view;

import com.sun.opengl.util.FPSAnimator;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.glu.GLU;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.viewer.model.Data;
import org.osm2world.viewer.model.MessageManager;
import org.osm2world.viewer.model.RenderOptions;
import org.osm2world.viewer.view.debug.DebugView;

public class ViewerGLCanvas
extends GLCanvas {
    public ViewerGLCanvas(Data data, MessageManager messageManager, RenderOptions renderOptions) {
        super(new GLCapabilities());
        this.setSize(800, 600);
        this.setIgnoreRepaint(true);
        this.addGLEventListener(new ViewerGLEventListener(data, messageManager, renderOptions));
        FPSAnimator fPSAnimator = new FPSAnimator((GLAutoDrawable)this, 60);
        fPSAnimator.setRunAsFastAsPossible(false);
        fPSAnimator.start();
    }

    public class ViewerGLEventListener
    implements GLEventListener {
        private final Data data;
        private final MessageManager messageManager;
        private final RenderOptions renderOptions;
        private final GLU glu = new GLU();

        public ViewerGLEventListener(Data data, MessageManager messageManager, RenderOptions renderOptions) {
            this.data = data;
            this.messageManager = messageManager;
            this.renderOptions = renderOptions;
        }

        public void display(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glClear(16640);
            if (this.renderOptions.camera != null) {
                // empty if block
            }
            JOGLTarget.setProjectionMatrices(gL, this.renderOptions.projection);
            gL.glLoadIdentity();
            if (this.renderOptions.camera != null) {
                JOGLTarget.setCameraMatrices(gL, this.renderOptions.camera);
            }
            if (this.renderOptions.isWireframe()) {
                gL.glPolygonMode(1032, 6913);
            } else {
                gL.glPolygonMode(1032, 6914);
            }
            if (this.renderOptions.isBackfaceCulling()) {
                gL.glEnable(2884);
            } else {
                gL.glDisable(2884);
            }
            for (DebugView object : this.renderOptions.activeDebugViews) {
                object.renderTo(gL, this.renderOptions.camera);
            }
            int n = 0;
            for (MessageManager.Message message : this.messageManager.getLiveMessages()) {
                new JOGLTarget(gL, this.renderOptions.camera).drawText(message.messageString, 10, 10 + n * 20, ViewerGLCanvas.this.getWidth(), ViewerGLCanvas.this.getHeight(), Color.WHITE);
                ++n;
            }
            gL.glFlush();
        }

        public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        }

        public void init(GLAutoDrawable gLAutoDrawable) {
            GL gL = gLAutoDrawable.getGL();
            gL.glFrontFace(2305);
            gL.glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
            gL.glEnable(2929);
            gL.glCullFace(1029);
        }

        public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            GL gL = gLAutoDrawable.getGL();
            if (n4 <= 0) {
                n4 = 1;
            }
            gL.glViewport(0, 0, n3, n4);
            this.renderOptions.projection = this.renderOptions.projection.withAspectRatio(n3 / n4);
        }
    }
}

