/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_elevation.data.ElevationProfile;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.map_elevation.data.NodeElevationProfile;
import org.osm2world.core.map_elevation.data.WaySegmentElevationProfile;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.jogl.RenderableToJOGL;
import org.osm2world.core.world.data.NodeWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.viewer.view.debug.DebugView;

public class ClearingDebugView
extends DebugView
implements RenderableToJOGL {
    private static final int LINE_WIDTH = 5;
    private static final float HALF_NODE_WIDTH = 0.4f;
    private static final int NODE_COLUMN_WIDTH = 5;
    private static final Color LINE_SURFACE_COLOR = Color.LIGHT_GRAY;
    private static final Color LINE_BELOW_COLOR = Color.YELLOW;
    private static final Color LINE_ABOVE_COLOR = Color.BLUE;
    private static final byte[] STIPPLE_PATTERN = new byte[]{17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120, 17, 17, 17, 17, -120, -120, -120, -120};

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        Object object;
        ElevationProfile elevationProfile;
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (MapWaySegment mapElement : this.map.getMapWaySegments()) {
            for (WaySegmentWorldObject waySegmentWorldObject : mapElement.getRepresentations()) {
                elevationProfile = mapElement.getElevationProfile();
                object = ((WaySegmentElevationProfile)elevationProfile).getPointsWithEle();
                int n = object.size();
                VectorXYZ[] vectorXYZArray = new VectorXYZ[n];
                VectorXYZ[] vectorXYZArray2 = new VectorXYZ[n];
                VectorXYZ[] vectorXYZArray3 = new VectorXYZ[n];
                VectorXYZ[] vectorXYZArray4 = new VectorXYZ[2 * n];
                for (int i = 0; i < n; ++i) {
                    VectorXYZ vectorXYZ;
                    vectorXYZArray[i] = vectorXYZ = (VectorXYZ)object.get(i);
                    VectorXYZ vectorXYZ2 = vectorXYZ.y(vectorXYZ.y - waySegmentWorldObject.getClearingBelow(vectorXYZ.xz()));
                    VectorXYZ vectorXYZ3 = vectorXYZ.y(vectorXYZ.y + waySegmentWorldObject.getClearingAbove(vectorXYZ.xz()));
                    vectorXYZArray2[i] = vectorXYZ2;
                    vectorXYZArray3[n - 1 - i] = vectorXYZ3;
                    vectorXYZArray4[i] = vectorXYZ2;
                    vectorXYZArray4[2 * n - 1 - i] = vectorXYZ3;
                }
                Color color = ClearingDebugView.getColorForState(waySegmentWorldObject.getGroundState());
                jOGLTarget.drawLineStrip(color, 5, vectorXYZArray);
                jOGLTarget.drawLineStrip(color, vectorXYZArray2);
                jOGLTarget.drawLineStrip(color, vectorXYZArray3);
                gL.glEnable(2882);
                gL.glPolygonStipple(STIPPLE_PATTERN, 0);
                jOGLTarget.drawPolygon(color, vectorXYZArray4);
                gL.glDisable(2882);
            }
        }
        for (MapNode mapNode : this.map.getMapNodes()) {
            for (NodeWorldObject nodeWorldObject : mapNode.getRepresentations()) {
                elevationProfile = mapNode.getElevationProfile();
                object = ClearingDebugView.getColorForState(nodeWorldObject.getGroundState());
                VectorXYZ vectorXYZ = ((NodeElevationProfile)elevationProfile).getPointWithEle();
                ClearingDebugView.drawBoxAround(jOGLTarget, ((NodeElevationProfile)elevationProfile).getPointWithEle(), (Color)object, 0.4f);
                jOGLTarget.drawLineStrip((Color)object, 5, vectorXYZ.y(vectorXYZ.y - nodeWorldObject.getClearingBelow(vectorXYZ.xz())), vectorXYZ.y(vectorXYZ.y + nodeWorldObject.getClearingAbove(vectorXYZ.xz())));
            }
        }
    }

    private static Color getColorForState(GroundState groundState) {
        if (groundState == GroundState.ABOVE) {
            return LINE_ABOVE_COLOR;
        }
        if (groundState == GroundState.BELOW) {
            return LINE_BELOW_COLOR;
        }
        return LINE_SURFACE_COLOR;
    }
}

