/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.heightmap.data.CellularTerrainElevation;
import org.osm2world.core.map_data.data.MapData;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.jogl.RenderableToJOGL;
import org.osm2world.core.target.primitivebuffer.PrimitiveBuffer;
import org.osm2world.core.terrain.data.Terrain;

public abstract class DebugView
implements RenderableToJOGL {
    protected MapData map;
    protected Terrain terrain;
    protected CellularTerrainElevation eleData;
    protected PrimitiveBuffer mapDataPrimitiveBuffer;
    protected PrimitiveBuffer terrainPrimitiveBuffer;

    public void setConversionResults(ConversionFacade.Results results) {
        this.map = results.getMapData();
        this.terrain = results.getTerrain();
        this.eleData = results.getEleData();
    }

    public void setPrimitiveBuffers(PrimitiveBuffer primitiveBuffer, PrimitiveBuffer primitiveBuffer2) {
        this.mapDataPrimitiveBuffer = primitiveBuffer;
        this.terrainPrimitiveBuffer = primitiveBuffer2;
    }

    public boolean canBeUsed() {
        return this.map != null && this.terrain != null && this.eleData != null && this.mapDataPrimitiveBuffer != null && this.terrainPrimitiveBuffer != null;
    }

    public String getDescription() {
        return "";
    }

    @Override
    public void renderTo(GL gL, Camera camera) {
        if (this.canBeUsed()) {
            this.renderToImpl(gL, camera);
        }
    }

    protected abstract void renderToImpl(GL var1, Camera var2);

    protected static final void drawBoxAround(JOGLTarget jOGLTarget, VectorXZ vectorXZ, Color color, float f) {
        DebugView.drawBoxAround(jOGLTarget, vectorXZ.xyz(0.0), color, f);
    }

    protected static final void drawBoxAround(JOGLTarget jOGLTarget, VectorXYZ vectorXYZ, Color color, float f) {
        DebugView.drawBox(jOGLTarget, color, new VectorXYZ(vectorXYZ.x - (double)f, vectorXYZ.y, vectorXYZ.z - (double)f), new VectorXYZ(vectorXYZ.x - (double)f, vectorXYZ.y, vectorXYZ.z + (double)f), new VectorXYZ(vectorXYZ.x + (double)f, vectorXYZ.y, vectorXYZ.z + (double)f), new VectorXYZ(vectorXYZ.x + (double)f, vectorXYZ.y, vectorXYZ.z - (double)f));
    }

    protected static final void drawBox(JOGLTarget jOGLTarget, Color color, VectorXYZ vectorXYZ, VectorXYZ vectorXYZ2, VectorXYZ vectorXYZ3, VectorXYZ vectorXYZ4) {
        jOGLTarget.drawLineStrip(color, vectorXYZ, vectorXYZ2, vectorXYZ3, vectorXYZ4, vectorXYZ);
    }
}

