/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.math.TriangleXYZ;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.terrain.data.TerrainPatch;
import org.osm2world.viewer.view.debug.DebugView;

public class EleDebugView
extends DebugView {
    @Override
    public String getDescription() {
        return "shows points with a color depending on their elevation";
    }

    @Override
    protected void renderToImpl(GL gL, Camera camera) {
        ArrayList<VectorXYZ> arrayList = new ArrayList<VectorXYZ>();
        for (TerrainPatch object : this.terrain.getPatches()) {
            for (TriangleXYZ triangleXYZ : object.getTriangulation()) {
                arrayList.addAll(triangleXYZ.getVertices());
            }
        }
        for (MapElement mapElement : this.map.getMapElements()) {
            if (mapElement.getElevationProfile() == null) continue;
            arrayList.addAll(mapElement.getElevationProfile().getPointsWithEle());
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (VectorXYZ vectorXYZ : arrayList) {
            d = Math.min(d, vectorXYZ.y);
            d2 = Math.max(d2, vectorXYZ.y);
        }
        double d3 = Math.max(d2 - d, 10.0);
        for (VectorXYZ vectorXYZ : arrayList) {
            double d4 = (vectorXYZ.y - d) / d3;
            Color color = this.interpolateGradientColor((float)d4, Color.GREEN, Color.YELLOW, Color.RED);
            EleDebugView.drawBoxAround(new JOGLTarget(gL, camera), vectorXYZ, color, 0.4f);
        }
    }

    private Color interpolateGradientColor(float f, Color ... colorArray) {
        assert (colorArray.length > 1);
        int n = colorArray.length - 1;
        float f2 = 1.0f / (float)n;
        int n2 = Math.min(Math.max((int)(f / f2), 0), n - 1);
        return this.interpolateGradientColor((f - f2 * (float)n2) / f2, colorArray[n2], colorArray[n2 + 1]);
    }

    private Color interpolateGradientColor(float f, Color color, Color color2) {
        return new Color(Math.round((float)color.getRed() * (1.0f - f) + (float)color2.getRed() * f), Math.round((float)color.getGreen() * (1.0f - f) + (float)color2.getGreen() * f), Math.round((float)color.getBlue() * (1.0f - f) + (float)color2.getBlue() * f));
    }
}

