/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GL;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.map_data.data.overlaps.MapIntersectionWW;
import org.osm2world.core.map_data.data.overlaps.MapOverlap;
import org.osm2world.core.map_data.data.overlaps.MapOverlapAA;
import org.osm2world.core.map_data.data.overlaps.MapOverlapWA;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.TriangleXZ;
import org.osm2world.core.math.Vector3D;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.TriangulationUtil;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.jogl.RenderableToJOGL;
import org.osm2world.viewer.view.debug.DebugView;

public class MapDataDebugView
extends DebugView
implements RenderableToJOGL {
    private static final Color LINE_COLOR = Color.WHITE;
    private static final Color NODE_COLOR = Color.YELLOW;
    private static final Color INTERSECTION_COLOR = Color.RED;
    private static final Color SHARED_SEGMENT_COLOR = Color.ORANGE;
    private static final Color AREA_COLOR = new Color(0.8f, 0.8f, 1.0f);
    private static final float HALF_NODE_WIDTH = 0.4f;

    @Override
    public String getDescription() {
        return "shows the map data (without elevation) as a network of nodes, lines and areas";
    }

    @Override
    public boolean canBeUsed() {
        return this.map != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (MapArea mapElement : this.map.getMapAreas()) {
            void var7_17;
            Vector3D[] vector3DArray = new Vector3D[mapElement.getBoundaryNodes().size()];
            boolean bl = false;
            while (var7_17 < mapElement.getBoundaryNodes().size()) {
                vector3DArray[var7_17] = mapElement.getBoundaryNodes().get((int)var7_17).getPos();
                ++var7_17;
            }
            List<TriangleXZ> list = TriangulationUtil.triangulate(mapElement.getPolygon());
            for (TriangleXZ triangleXZ : list) {
                jOGLTarget.drawTriangles(AREA_COLOR, Collections.singleton(triangleXZ.xyz(-0.1)));
            }
        }
        for (MapWaySegment mapWaySegment : this.map.getMapWaySegments()) {
            jOGLTarget.drawArrow(LINE_COLOR, 0.7f, mapWaySegment.getStartNode().getPos().xyz(0.0), mapWaySegment.getEndNode().getPos().xyz(0.0));
        }
        for (MapNode mapNode : this.map.getMapNodes()) {
            MapDataDebugView.drawBoxAround(jOGLTarget, mapNode.getPos(), NODE_COLOR, 0.4f);
        }
        for (MapWaySegment mapWaySegment : this.map.getMapWaySegments()) {
            for (MapIntersectionWW mapIntersectionWW : mapWaySegment.getIntersectionsWW()) {
                MapDataDebugView.drawBoxAround(jOGLTarget, mapIntersectionWW.pos, INTERSECTION_COLOR, 0.4f);
            }
        }
        for (MapArea mapArea : this.map.getMapAreas()) {
            for (MapOverlap mapOverlap : mapArea.getOverlaps()) {
                if (mapOverlap instanceof MapOverlapWA) {
                    for (VectorXZ vectorXZ : ((MapOverlapWA)mapOverlap).getIntersectionPositions()) {
                        MapDataDebugView.drawBoxAround(jOGLTarget, vectorXZ, INTERSECTION_COLOR, 0.4f);
                    }
                    for (LineSegmentXZ lineSegmentXZ : ((MapOverlapWA)mapOverlap).getSharedSegments()) {
                        jOGLTarget.drawLineStrip(SHARED_SEGMENT_COLOR, 3, lineSegmentXZ.p1.xyz(0.0), lineSegmentXZ.p2.xyz(0.0));
                    }
                    for (LineSegmentXZ lineSegmentXZ : ((MapOverlapWA)mapOverlap).getOverlappedSegments()) {
                        jOGLTarget.drawLineStrip(INTERSECTION_COLOR, 3, lineSegmentXZ.p1.xyz(0.0), lineSegmentXZ.p2.xyz(0.0));
                    }
                    continue;
                }
                if (!(mapOverlap instanceof MapOverlapAA)) continue;
                for (VectorXZ vectorXZ : ((MapOverlapAA)mapOverlap).getIntersectionPositions()) {
                    MapDataDebugView.drawBoxAround(jOGLTarget, vectorXZ, INTERSECTION_COLOR, 0.4f);
                }
            }
        }
    }
}

