/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.viewer.view.debug.DebugView;

public class MapDataElevationDebugView
extends DebugView {
    private static final Color LINE_COLOR = Color.WHITE;
    private static final Color NODE_COLOR = Color.YELLOW;
    private static final Color POINT_WITH_ELE_COLOR = Color.LIGHT_GRAY;
    private static final float HALF_NODE_WIDTH = 0.4f;
    private static final float HALF_POINT_WITH_ELE_WIDTH = 0.2f;

    @Override
    public String getDescription() {
        return "shows the MapData (with elevation) as a network of nodes, lines and areas";
    }

    @Override
    public boolean canBeUsed() {
        return this.map != null;
    }

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (MapArea mapElement : this.map.getMapAreas()) {
            if (mapElement.getElevationProfile() == null) continue;
            for (VectorXYZ vectorXYZ : mapElement.getElevationProfile().getPointsWithEle()) {
                MapDataElevationDebugView.drawBoxAround(jOGLTarget, vectorXYZ, POINT_WITH_ELE_COLOR, 0.2f);
            }
        }
        for (MapWaySegment mapWaySegment : this.map.getMapWaySegments()) {
            if (mapWaySegment.getElevationProfile() == null) continue;
            jOGLTarget.drawArrow(LINE_COLOR, 0.7f, mapWaySegment.getElevationProfile().getPointsWithEle().toArray(new VectorXYZ[0]));
            for (VectorXYZ vectorXYZ : mapWaySegment.getElevationProfile().getPointsWithEle()) {
                MapDataElevationDebugView.drawBoxAround(jOGLTarget, vectorXYZ, POINT_WITH_ELE_COLOR, 0.2f);
            }
        }
        for (MapNode mapNode : this.map.getMapNodes()) {
            if (mapNode.getElevationProfile() == null) continue;
            MapDataElevationDebugView.drawBoxAround(jOGLTarget, mapNode.getElevationProfile().getPointWithEle(), NODE_COLOR, 0.4f);
        }
    }
}

