/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.core.world.network.NetworkWaySegmentWorldObject;
import org.osm2world.viewer.view.debug.DebugView;

public class NetworkDebugView
extends DebugView {
    private static final Color OFFSET_COLOR = Color.PINK;
    private static final Color CUT_COLOR = Color.ORANGE;

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (MapWaySegment mapWaySegment : this.map.getMapWaySegments()) {
            for (WaySegmentWorldObject waySegmentWorldObject : mapWaySegment.getRepresentations()) {
                if (!(waySegmentWorldObject instanceof NetworkWaySegmentWorldObject)) continue;
                NetworkWaySegmentWorldObject networkWaySegmentWorldObject = (NetworkWaySegmentWorldObject)((Object)waySegmentWorldObject);
                NetworkDebugView.drawVectorAt(jOGLTarget, OFFSET_COLOR, networkWaySegmentWorldObject.getStartOffset(), mapWaySegment.getStartNode());
                NetworkDebugView.drawVectorAt(jOGLTarget, OFFSET_COLOR, networkWaySegmentWorldObject.getEndOffset(), mapWaySegment.getEndNode());
                NetworkDebugView.drawVectorAt(jOGLTarget, CUT_COLOR, networkWaySegmentWorldObject.getStartCutVector(), mapWaySegment.getStartNode());
                NetworkDebugView.drawVectorAt(jOGLTarget, CUT_COLOR, networkWaySegmentWorldObject.getEndCutVector(), mapWaySegment.getEndNode());
            }
        }
    }

    private static void drawVectorAt(JOGLTarget jOGLTarget, Color color, VectorXZ vectorXZ, MapNode mapNode) {
        VectorXYZ vectorXYZ = mapNode.getPos().xyz(0.0);
        VectorXYZ vectorXYZ2 = vectorXYZ.add(vectorXZ);
        jOGLTarget.drawArrow(color, 0.3f * (float)vectorXZ.length(), vectorXYZ, vectorXYZ2);
    }
}

