/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import java.util.List;
import javax.media.opengl.GL;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.common.rendering.OrthoTilesUtil;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.jogl.RenderableToJOGL;
import org.osm2world.viewer.view.debug.DebugView;

public class OrthoBoundsDebugView
extends DebugView
implements RenderableToJOGL {
    private static final Color LINE_COLOR = Color.YELLOW;
    private static final Color POINT_COLOR = Color.RED;
    private static final float HALF_POINT_WIDTH = 0.4f;

    @Override
    public String getDescription() {
        return "illustrates the construction of the orthogonal perspective";
    }

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        if (this.map == null) {
            return;
        }
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        Camera camera2 = OrthoTilesUtil.cameraForBounds(this.map.getBoundary(), 30.0, OrthoTilesUtil.CardinalDirection.S);
        List<VectorXYZ> list = this.map.getBoundary().polygonXZ().xyz(0.0).getVertices();
        jOGLTarget.drawLineLoop(LINE_COLOR, list);
        jOGLTarget.drawLineStrip(LINE_COLOR, list.get(0), list.get(2));
        jOGLTarget.drawLineStrip(LINE_COLOR, list.get(1), list.get(3));
        OrthoBoundsDebugView.drawBoxAround(jOGLTarget, camera2.getPos(), POINT_COLOR, 0.4f);
        OrthoBoundsDebugView.drawBoxAround(jOGLTarget, camera2.getLookAt(), POINT_COLOR, 0.4f);
        jOGLTarget.drawLineStrip(LINE_COLOR, camera2.getPos(), camera2.getLookAt());
    }
}

