/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import java.util.Arrays;
import javax.media.opengl.GL;
import org.osm2world.core.ConversionFacade;
import org.osm2world.core.map_data.data.MapArea;
import org.osm2world.core.map_data.data.MapElement;
import org.osm2world.core.map_data.data.MapNode;
import org.osm2world.core.map_data.data.MapQuadtree;
import org.osm2world.core.map_data.data.MapWaySegment;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.viewer.view.debug.DebugView;

public class QuadtreeDebugView
extends DebugView {
    private static final Color LEAF_BORDER_COLOR = Color.WHITE;
    private static final Color NODE_ARROW_COLOR = Color.YELLOW;
    private static final Color LINE_ARROW_COLOR = Color.LIGHT_GRAY;
    private static final Color AREA_ARROW_COLOR = new Color(0.8f, 0.8f, 1.0f);
    private MapQuadtree mapQuadtree;
    private boolean arrowsEnabled = true;

    @Override
    public void setConversionResults(ConversionFacade.Results results) {
        super.setConversionResults(results);
        this.mapQuadtree = new MapQuadtree(this.map);
    }

    public void setArrowsEnabled(boolean bl) {
        this.arrowsEnabled = bl;
    }

    @Override
    public boolean canBeUsed() {
        return this.mapQuadtree != null;
    }

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (MapQuadtree.QuadLeaf quadLeaf : this.mapQuadtree.getLeaves()) {
            VectorXZ[] vectorXZArray;
            vectorXZArray = new VectorXZ[]{new VectorXZ(quadLeaf.minX, quadLeaf.minZ), new VectorXZ(quadLeaf.maxX, quadLeaf.minZ), new VectorXZ(quadLeaf.maxX, quadLeaf.maxZ), new VectorXZ(quadLeaf.minX, quadLeaf.maxZ), vectorXZArray[0]};
            jOGLTarget.drawLineStrip(LEAF_BORDER_COLOR, VectorXZ.listXYZ(Arrays.asList(vectorXZArray), 0.0));
            if (!this.arrowsEnabled) continue;
            VectorXZ vectorXZ = new VectorXZ((quadLeaf.minX + quadLeaf.maxX) / 2.0, (quadLeaf.minZ + quadLeaf.maxZ) / 2.0);
            for (MapElement mapElement : quadLeaf.getElements()) {
                VectorXZ vectorXZ2;
                if (mapElement instanceof MapNode) {
                    vectorXZ2 = ((MapNode)mapElement).getPos();
                    jOGLTarget.drawArrow(NODE_ARROW_COLOR, (float)Math.min(1.0, VectorXZ.distance(vectorXZ, vectorXZ2) * 0.3), vectorXZ.xyz(0.0), vectorXZ2.xyz(0.0));
                    continue;
                }
                if (mapElement instanceof MapWaySegment) {
                    vectorXZ2 = ((MapWaySegment)mapElement).getStartNode().getPos();
                    VectorXZ vectorXZ3 = ((MapWaySegment)mapElement).getEndNode().getPos();
                    VectorXZ vectorXZ4 = vectorXZ2.add(vectorXZ3).mult(0.5);
                    float f = (float)Math.min(1.0, VectorXZ.distance(vectorXZ, vectorXZ4) * 0.3);
                    jOGLTarget.drawArrow(LINE_ARROW_COLOR, f, vectorXZ.xyz(0.0), vectorXZ4.xyz(0.0));
                    continue;
                }
                if (!(mapElement instanceof MapArea)) continue;
                vectorXZ2 = ((MapArea)mapElement).getOuterPolygon().getCenter();
                float f = (float)Math.min(1.0, VectorXZ.distance(vectorXZ, vectorXZ2) * 0.3);
                jOGLTarget.drawArrow(AREA_ARROW_COLOR, f, vectorXZ.xyz(0.0), vectorXZ2.xyz(0.0));
            }
        }
    }
}

