/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.math.LineSegmentXZ;
import org.osm2world.core.math.PolygonXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.world.modules.BuildingModule;
import org.osm2world.viewer.view.debug.DebugView;

public class RoofDataDebugView
extends DebugView {
    private static final Color INNER_POINT_COLOR = Color.YELLOW;
    private static final Color INNER_SEGMENT_COLOR = Color.GREEN;
    private static final Color POLYGON_COLOR = Color.BLUE;

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (BuildingModule.Building building : this.map.getWorldObjects(BuildingModule.Building.class)) {
            for (BuildingModule.BuildingPart buildingPart : building.getParts()) {
                if (!(buildingPart.getRoof() instanceof BuildingModule.BuildingPart.HeightfieldRoof)) {
                    return;
                }
                BuildingModule.BuildingPart.HeightfieldRoof heightfieldRoof = (BuildingModule.BuildingPart.HeightfieldRoof)buildingPart.getRoof();
                for (SimplePolygonXZ simplePolygonXZ : heightfieldRoof.getPolygon().getPolygons()) {
                    for (VectorXZ vectorXZ : simplePolygonXZ.getVertices()) {
                        RoofDataDebugView.drawBoxAround(jOGLTarget, vectorXZ, POLYGON_COLOR, 0.3f);
                    }
                    for (LineSegmentXZ lineSegmentXZ : ((PolygonXZ)simplePolygonXZ).getSegments()) {
                        jOGLTarget.drawLineStrip(POLYGON_COLOR, lineSegmentXZ.p1.xyz(0.0), lineSegmentXZ.p2.xyz(0.0));
                    }
                }
                for (VectorXZ vectorXZ : heightfieldRoof.getInnerPoints()) {
                    RoofDataDebugView.drawBoxAround(jOGLTarget, vectorXZ, INNER_POINT_COLOR, 0.5f);
                }
                for (LineSegmentXZ lineSegmentXZ : heightfieldRoof.getInnerSegments()) {
                    jOGLTarget.drawLineStrip(INNER_SEGMENT_COLOR, lineSegmentXZ.p1.xyz(0.0), lineSegmentXZ.p2.xyz(0.0));
                }
            }
        }
    }
}

