/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.math.AxisAlignedBoundingBoxXZ;
import org.osm2world.core.math.SimplePolygonXZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.viewer.view.debug.DebugView;

public class TerrainBoundaryAABBDebugView
extends DebugView {
    private static final Color BB_COLOR = Color.RED;

    @Override
    public String getDescription() {
        return "shows the axis-aligned bounding boxes of the terrain boundaries";
    }

    @Override
    protected void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (TerrainBoundaryWorldObject terrainBoundaryWorldObject : this.map.getWorldObjects(TerrainBoundaryWorldObject.class)) {
            AxisAlignedBoundingBoxXZ axisAlignedBoundingBoxXZ = terrainBoundaryWorldObject.getAxisAlignedBoundingBoxXZ();
            if (axisAlignedBoundingBoxXZ == null) continue;
            SimplePolygonXZ simplePolygonXZ = axisAlignedBoundingBoxXZ.polygonXZ();
            jOGLTarget.drawLineLoop(BB_COLOR, simplePolygonXZ.xyz(0.0).getVertices());
        }
    }
}

