/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.map_elevation.data.GroundState;
import org.osm2world.core.math.PolygonXYZ;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.world.data.AreaWorldObject;
import org.osm2world.core.world.data.TerrainBoundaryWorldObject;
import org.osm2world.core.world.data.WaySegmentWorldObject;
import org.osm2world.viewer.view.debug.DebugView;

public class TerrainBoundaryDebugView
extends DebugView {
    private static final Color NODE_BOUNDARY_COLOR = Color.YELLOW;
    private static final Color WAY_BOUNDARY_COLOR = Color.GREEN;
    private static final Color AREA_BOUNDARY_COLOR = Color.BLUE;

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (TerrainBoundaryWorldObject terrainBoundaryWorldObject : this.map.getWorldObjects(TerrainBoundaryWorldObject.class)) {
            PolygonXYZ polygonXYZ;
            if (terrainBoundaryWorldObject.getGroundState() != GroundState.ON) continue;
            Color color = NODE_BOUNDARY_COLOR;
            if (terrainBoundaryWorldObject instanceof WaySegmentWorldObject) {
                color = WAY_BOUNDARY_COLOR;
            } else if (terrainBoundaryWorldObject instanceof AreaWorldObject) {
                color = AREA_BOUNDARY_COLOR;
            }
            if ((polygonXYZ = terrainBoundaryWorldObject.getOutlinePolygon()) == null) continue;
            jOGLTarget.drawLineLoop(color, polygonXYZ.getVertices());
        }
    }
}

