/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.heightmap.data.TerrainPoint;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.target.jogl.RenderableToJOGL;
import org.osm2world.viewer.view.debug.DebugView;

public class TerrainElevationGridDebugView
extends DebugView
implements RenderableToJOGL {
    private static final Color NODE_COLOR = Color.LIGHT_GRAY;
    private static final Color GRID_COLOR = Color.LIGHT_GRAY;

    @Override
    public void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        TerrainPoint[][] terrainPointArray = this.eleData.getTerrainPointGrid();
        for (int i = 0; i < terrainPointArray.length; ++i) {
            for (int j = 0; j < terrainPointArray[i].length; ++j) {
                if (i + 1 < terrainPointArray.length) {
                    jOGLTarget.drawLineStrip(GRID_COLOR, 1, terrainPointArray[i][j].getPosXYZ(), terrainPointArray[i + 1][j].getPosXYZ());
                }
                if (j + 1 >= terrainPointArray[i].length) continue;
                jOGLTarget.drawLineStrip(GRID_COLOR, 1, terrainPointArray[i][j].getPosXYZ(), terrainPointArray[i][j + 1].getPosXYZ());
            }
        }
        for (TerrainPoint terrainPoint : this.eleData.getTerrainPoints()) {
            jOGLTarget.drawPoints(NODE_COLOR, terrainPoint.getPosXYZ());
        }
    }
}

