/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import javax.media.opengl.GL;
import org.osm2world.core.math.VectorXYZ;
import org.osm2world.core.target.common.Primitive;
import org.osm2world.core.target.common.material.Material;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.viewer.view.debug.DebugView;

public class TerrainNormalsDebugView
extends DebugView {
    private static final Color FLAT_NORMALS_COLOR = Color.YELLOW;
    private static final Color SMOOTH_NORMALS_COLOR = Color.ORANGE;

    @Override
    public String getDescription() {
        return "draws terrain normals as arrows";
    }

    @Override
    protected void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (Material material : this.terrainPrimitiveBuffer.getMaterials()) {
            Color color = material.getLighting() == Material.Lighting.FLAT ? FLAT_NORMALS_COLOR : SMOOTH_NORMALS_COLOR;
            for (Primitive primitive : this.terrainPrimitiveBuffer.getPrimitives(material)) {
                for (int i = 0; i < primitive.indices.length; ++i) {
                    int n = primitive.indices[i];
                    VectorXYZ vectorXYZ = this.terrainPrimitiveBuffer.getVertex(n);
                    jOGLTarget.drawArrow(color, 0.3f, vectorXYZ, vectorXYZ.add(primitive.normals[i]));
                }
            }
        }
    }
}

