/*
 * Decompiled with CFR 0.152.
 */
package org.osm2world.viewer.view.debug;

import java.awt.Color;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.osm2world.core.math.VectorXZ;
import org.osm2world.core.math.algorithms.EarClippingTriangulationUtil;
import org.osm2world.core.target.common.rendering.Camera;
import org.osm2world.core.target.jogl.JOGLTarget;
import org.osm2world.core.terrain.data.GenericTerrainPatch;
import org.osm2world.core.terrain.data.TerrainPatch;
import org.osm2world.viewer.view.debug.DebugView;

public class TerrainOutlineDebugView
extends DebugView {
    private static final Color OUTLINE_COLOR = Color.GREEN;
    private static final Color POINT_COLOR = Color.YELLOW;

    @Override
    public String getDescription() {
        return "shows the terrain polygons immediately before triangulation";
    }

    @Override
    protected void renderToImpl(GL gL, Camera camera) {
        JOGLTarget jOGLTarget = new JOGLTarget(gL, camera);
        for (TerrainPatch terrainPatch : this.terrain.getPatches()) {
            if (!(terrainPatch instanceof GenericTerrainPatch)) continue;
            GenericTerrainPatch genericTerrainPatch = (GenericTerrainPatch)terrainPatch;
            ArrayList<VectorXZ> arrayList = new ArrayList<VectorXZ>(genericTerrainPatch.getPolygon().getOuter().getVertexLoop());
            EarClippingTriangulationUtil.insertHolesInPolygonOutline(arrayList, genericTerrainPatch.getPolygon().getHoles());
            jOGLTarget.drawLineStrip(OUTLINE_COLOR, VectorXZ.listXYZ(arrayList, 0.0));
            for (VectorXZ vectorXZ : genericTerrainPatch.getPoints()) {
                TerrainOutlineDebugView.drawBoxAround(jOGLTarget, vectorXZ, POINT_COLOR, 0.5f);
            }
        }
    }
}

