/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryListAdapter<K, V>
extends AbstractSequentialList<V> {
    private final Iterable<? extends Map.Entry<K, V>> iterable;

    public EntryListAdapter(Iterable<? extends Map.Entry<K, V>> iterable) {
        this.iterable = iterable;
    }

    @Override
    public Iterator<V> iterator() {
        return new ValueIterator(this.iterable);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return new ValueListIterator(this.iterable, index);
    }

    @Override
    public boolean isEmpty() {
        return false == this.iterator().hasNext();
    }

    @Override
    public int size() {
        int size = 0;
        Iterator<Map.Entry<K, V>> i = this.iterable.iterator();
        while (i.hasNext()) {
            ++size;
            i.next();
        }
        return size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueIterator<K, V>
    implements Iterator<V> {
        private final Iterator<? extends Map.Entry<K, V>> iterator;

        ValueIterator(Iterable<? extends Map.Entry<K, V>> iterable) {
            this.iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ValueListIterator<K, V>
    implements ListIterator<V> {
        private final Iterator<? extends Map.Entry<K, V>> iterator;
        private final List<Map.Entry<K, V>> entryCache = new ArrayList<Map.Entry<K, V>>();
        private int index;

        ValueListIterator(Iterable<? extends Map.Entry<K, V>> iterable, int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.iterator = iterable.iterator();
            try {
                while (this.index < index) {
                    this.next();
                }
            }
            catch (NoSuchElementException e) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < this.entryCache.size() || this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public V next() {
            if (this.index >= this.entryCache.size()) {
                this.entryCache.add(this.iterator.next());
            }
            return this.entryCache.get(this.index++).getValue();
        }

        @Override
        public V previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            return this.entryCache.get(--this.index).getValue();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void add(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(V o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

