/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.MolleweideProjection;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.SinusoidalProjection;
import java.awt.geom.Point2D;

public class GoodeProjection
extends Projection {
    private static final double Y_COR = 0.0528;
    private static final double PHI_LIM = 0.7109307819790236;
    private SinusoidalProjection sinu = new SinusoidalProjection();
    private MolleweideProjection moll = new MolleweideProjection();

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        if (Math.abs(lpphi) <= 0.7109307819790236) {
            out = this.sinu.project(lplam, lpphi, out);
        } else {
            out = this.moll.project(lplam, lpphi, out);
            out.y = out.y - (lpphi >= 0.0 ? 0.0528 : -0.0528);
        }
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out = Math.abs(xyy) <= 0.7109307819790236 ? this.sinu.projectInverse(xyx, xyy, out) : this.moll.projectInverse(xyx, xyy += xyy >= 0.0 ? 0.0528 : -0.0528, out);
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Goode Homolosine";
    }
}

