/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.AngleFormat;
import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Ellipsoid;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.FieldPosition;

public class Projection
implements Cloneable {
    protected double minLatitude = -1.5707963267948966;
    protected double minLongitude = -Math.PI;
    protected double maxLatitude = 1.5707963267948966;
    protected double maxLongitude = Math.PI;
    protected double projectionLatitude = 0.0;
    protected double projectionLongitude = 0.0;
    protected double projectionLatitude1 = 0.0;
    protected double projectionLatitude2 = 0.0;
    protected double scaleFactor = 1.0;
    protected double falseEasting = 0.0;
    protected double falseNorthing = 0.0;
    protected double trueScaleLatitude = 0.0;
    protected double a = 0.0;
    protected double e = 0.0;
    protected double es = 0.0;
    protected double one_es = 0.0;
    protected double rone_es = 0.0;
    protected Ellipsoid ellipsoid;
    protected boolean spherical;
    protected boolean geocentric;
    protected String name = null;
    protected double fromMetres = 1.0;
    private double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    protected static final double EPS10 = 1.0E-10;
    protected static final double RTD = 57.29577951308232;
    protected static final double DTR = Math.PI / 180;

    protected Projection() {
        this.setEllipsoid(Ellipsoid.SPHERE);
    }

    public Object clone() {
        try {
            Projection e = (Projection)super.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Point2D.Double transform(Point2D.Double src, Point2D.Double dst) {
        double x = src.x * (Math.PI / 180);
        if (this.projectionLongitude != 0.0) {
            x = MapMath.normalizeLongitude(x - this.projectionLongitude);
        }
        this.project(x, src.y * (Math.PI / 180), dst);
        dst.x = this.totalScale * dst.x + this.totalFalseEasting;
        dst.y = this.totalScale * dst.y + this.totalFalseNorthing;
        return dst;
    }

    public Point2D.Double transformRadians(Point2D.Double src, Point2D.Double dst) {
        double x = src.x;
        if (this.projectionLongitude != 0.0) {
            x = MapMath.normalizeLongitude(x - this.projectionLongitude);
        }
        this.project(x, src.y, dst);
        dst.x = this.totalScale * dst.x + this.totalFalseEasting;
        dst.y = this.totalScale * dst.y + this.totalFalseNorthing;
        return dst;
    }

    public Point2D.Double project(double x, double y, Point2D.Double dst) {
        dst.x = x;
        dst.y = y;
        return dst;
    }

    public void transform(double[] srcPoints, int srcOffset, double[] dstPoints, int dstOffset, int numPoints) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        for (int i = 0; i < numPoints; ++i) {
            in.x = srcPoints[srcOffset++];
            in.y = srcPoints[srcOffset++];
            this.transform(in, out);
            dstPoints[dstOffset++] = out.x;
            dstPoints[dstOffset++] = out.y;
        }
    }

    public void transformRadians(double[] srcPoints, int srcOffset, double[] dstPoints, int dstOffset, int numPoints) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        for (int i = 0; i < numPoints; ++i) {
            in.x = srcPoints[srcOffset++];
            in.y = srcPoints[srcOffset++];
            this.transform(in, out);
            dstPoints[dstOffset++] = out.x;
            dstPoints[dstOffset++] = out.y;
        }
    }

    public Point2D.Double inverseTransform(Point2D.Double src, Point2D.Double dst) {
        double x = (src.x - this.totalFalseEasting) / this.totalScale;
        double y = (src.y - this.totalFalseNorthing) / this.totalScale;
        this.projectInverse(x, y, dst);
        if (dst.x < -Math.PI) {
            dst.x = -Math.PI;
        } else if (dst.x > Math.PI) {
            dst.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst.x = MapMath.normalizeLongitude(dst.x + this.projectionLongitude);
        }
        dst.x *= 57.29577951308232;
        dst.y *= 57.29577951308232;
        return dst;
    }

    public Point2D.Double inverseTransformRadians(Point2D.Double src, Point2D.Double dst) {
        double x = (src.x - this.totalFalseEasting) / this.totalScale;
        double y = (src.y - this.totalFalseNorthing) / this.totalScale;
        this.projectInverse(x, y, dst);
        if (dst.x < -Math.PI) {
            dst.x = -Math.PI;
        } else if (dst.x > Math.PI) {
            dst.x = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst.x = MapMath.normalizeLongitude(dst.x + this.projectionLongitude);
        }
        return dst;
    }

    public Point2D.Double projectInverse(double x, double y, Point2D.Double dst) {
        dst.x = x;
        dst.y = y;
        return dst;
    }

    public void inverseTransform(double[] srcPoints, int srcOffset, double[] dstPoints, int dstOffset, int numPoints) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        for (int i = 0; i < numPoints; ++i) {
            in.x = srcPoints[srcOffset++];
            in.y = srcPoints[srcOffset++];
            this.inverseTransform(in, out);
            dstPoints[dstOffset++] = out.x;
            dstPoints[dstOffset++] = out.y;
        }
    }

    public void inverseTransformRadians(double[] srcPoints, int srcOffset, double[] dstPoints, int dstOffset, int numPoints) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        for (int i = 0; i < numPoints; ++i) {
            in.x = srcPoints[srcOffset++];
            in.y = srcPoints[srcOffset++];
            this.inverseTransformRadians(in, out);
            dstPoints[dstOffset++] = out.x;
            dstPoints[dstOffset++] = out.y;
        }
    }

    public Rectangle2D inverseTransform(Rectangle2D r) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        Rectangle2D bounds = null;
        if (this.isRectilinear()) {
            for (int ix = 0; ix < 2; ++ix) {
                double x = r.getX() + r.getWidth() * (double)ix;
                for (int iy = 0; iy < 2; ++iy) {
                    double y = r.getY() + r.getHeight() * (double)iy;
                    in.x = x;
                    in.y = y;
                    this.inverseTransform(in, out);
                    if (ix == 0 && iy == 0) {
                        bounds = new Rectangle2D.Double(out.x, out.y, 0.0, 0.0);
                        continue;
                    }
                    bounds.add(out.x, out.y);
                }
            }
        } else {
            for (int ix = 0; ix < 7; ++ix) {
                double x = r.getX() + r.getWidth() * (double)ix / 6.0;
                for (int iy = 0; iy < 7; ++iy) {
                    double y = r.getY() + r.getHeight() * (double)iy / 6.0;
                    in.x = x;
                    in.y = y;
                    this.inverseTransform(in, out);
                    if (ix == 0 && iy == 0) {
                        bounds = new Rectangle2D.Double(out.x, out.y, 0.0, 0.0);
                        continue;
                    }
                    bounds.add(out.x, out.y);
                }
            }
        }
        return bounds;
    }

    public Rectangle2D transform(Rectangle2D r) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        Rectangle2D bounds = null;
        if (this.isRectilinear()) {
            for (int ix = 0; ix < 2; ++ix) {
                double x = r.getX() + r.getWidth() * (double)ix;
                for (int iy = 0; iy < 2; ++iy) {
                    double y = r.getY() + r.getHeight() * (double)iy;
                    in.x = x;
                    in.y = y;
                    this.transform(in, out);
                    if (ix == 0 && iy == 0) {
                        bounds = new Rectangle2D.Double(out.x, out.y, 0.0, 0.0);
                        continue;
                    }
                    bounds.add(out.x, out.y);
                }
            }
        } else {
            for (int ix = 0; ix < 7; ++ix) {
                double x = r.getX() + r.getWidth() * (double)ix / 6.0;
                for (int iy = 0; iy < 7; ++iy) {
                    double y = r.getY() + r.getHeight() * (double)iy / 6.0;
                    in.x = x;
                    in.y = y;
                    this.transform(in, out);
                    if (ix == 0 && iy == 0) {
                        bounds = new Rectangle2D.Double(out.x, out.y, 0.0, 0.0);
                        continue;
                    }
                    bounds.add(out.x, out.y);
                }
            }
        }
        return bounds;
    }

    public boolean isConformal() {
        return false;
    }

    public boolean isEqualArea() {
        return false;
    }

    public boolean hasInverse() {
        return false;
    }

    public boolean isRectilinear() {
        return false;
    }

    public boolean parallelsAreParallel() {
        return this.isRectilinear();
    }

    public boolean inside(double x, double y) {
        return this.minLongitude <= (x = (double)Projection.normalizeLongitude((float)(x * (Math.PI / 180) - this.projectionLongitude))) && x <= this.maxLongitude && this.minLatitude <= y && y <= this.maxLatitude;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.toString();
    }

    public String getPROJ4Description() {
        AngleFormat format = new AngleFormat("DdM", false);
        StringBuffer sb = new StringBuffer();
        sb.append("+proj=" + this.getName() + " +a=" + this.a);
        if (this.es != 0.0) {
            sb.append(" +es=" + this.es);
        }
        sb.append(" +lon_0=");
        format.format(this.projectionLongitude, sb, (FieldPosition)null);
        sb.append(" +lat_0=");
        format.format(this.projectionLatitude, sb, (FieldPosition)null);
        if (this.falseEasting != 1.0) {
            sb.append(" +x_0=" + this.falseEasting);
        }
        if (this.falseNorthing != 1.0) {
            sb.append(" +y_0=" + this.falseNorthing);
        }
        if (this.scaleFactor != 1.0) {
            sb.append(" +k=" + this.scaleFactor);
        }
        if (this.fromMetres != 1.0) {
            sb.append(" +fr_meters=" + this.fromMetres);
        }
        return sb.toString();
    }

    public String toString() {
        return "None";
    }

    public void setMinLatitude(double minLatitude) {
        this.minLatitude = minLatitude;
    }

    public double getMinLatitude() {
        return this.minLatitude;
    }

    public void setMaxLatitude(double maxLatitude) {
        this.maxLatitude = maxLatitude;
    }

    public double getMaxLatitude() {
        return this.maxLatitude;
    }

    public double getMaxLatitudeDegrees() {
        return this.maxLatitude * 57.29577951308232;
    }

    public double getMinLatitudeDegrees() {
        return this.minLatitude * 57.29577951308232;
    }

    public void setMinLongitude(double minLongitude) {
        this.minLongitude = minLongitude;
    }

    public double getMinLongitude() {
        return this.minLongitude;
    }

    public void setMinLongitudeDegrees(double minLongitude) {
        this.minLongitude = Math.PI / 180 * minLongitude;
    }

    public double getMinLongitudeDegrees() {
        return this.minLongitude * 57.29577951308232;
    }

    public void setMaxLongitude(double maxLongitude) {
        this.maxLongitude = maxLongitude;
    }

    public double getMaxLongitude() {
        return this.maxLongitude;
    }

    public void setMaxLongitudeDegrees(double maxLongitude) {
        this.maxLongitude = Math.PI / 180 * maxLongitude;
    }

    public double getMaxLongitudeDegrees() {
        return this.maxLongitude * 57.29577951308232;
    }

    public void setProjectionLatitude(double projectionLatitude) {
        this.projectionLatitude = projectionLatitude;
    }

    public double getProjectionLatitude() {
        return this.projectionLatitude;
    }

    public void setProjectionLatitudeDegrees(double projectionLatitude) {
        this.projectionLatitude = Math.PI / 180 * projectionLatitude;
    }

    public double getProjectionLatitudeDegrees() {
        return this.projectionLatitude * 57.29577951308232;
    }

    public void setProjectionLongitude(double projectionLongitude) {
        this.projectionLongitude = Projection.normalizeLongitudeRadians(projectionLongitude);
    }

    public double getProjectionLongitude() {
        return this.projectionLongitude;
    }

    public void setProjectionLongitudeDegrees(double projectionLongitude) {
        this.projectionLongitude = Math.PI / 180 * projectionLongitude;
    }

    public double getProjectionLongitudeDegrees() {
        return this.projectionLongitude * 57.29577951308232;
    }

    public void setTrueScaleLatitude(double trueScaleLatitude) {
        this.trueScaleLatitude = trueScaleLatitude;
    }

    public double getTrueScaleLatitude() {
        return this.trueScaleLatitude;
    }

    public void setTrueScaleLatitudeDegrees(double trueScaleLatitude) {
        this.trueScaleLatitude = Math.PI / 180 * trueScaleLatitude;
    }

    public double getTrueScaleLatitudeDegrees() {
        return this.trueScaleLatitude * 57.29577951308232;
    }

    public void setProjectionLatitude1(double projectionLatitude1) {
        this.projectionLatitude1 = projectionLatitude1;
    }

    public double getProjectionLatitude1() {
        return this.projectionLatitude1;
    }

    public void setProjectionLatitude1Degrees(double projectionLatitude1) {
        this.projectionLatitude1 = Math.PI / 180 * projectionLatitude1;
    }

    public double getProjectionLatitude1Degrees() {
        return this.projectionLatitude1 * 57.29577951308232;
    }

    public void setProjectionLatitude2(double projectionLatitude2) {
        this.projectionLatitude2 = projectionLatitude2;
    }

    public double getProjectionLatitude2() {
        return this.projectionLatitude2;
    }

    public void setProjectionLatitude2Degrees(double projectionLatitude2) {
        this.projectionLatitude2 = Math.PI / 180 * projectionLatitude2;
    }

    public double getProjectionLatitude2Degrees() {
        return this.projectionLatitude2 * 57.29577951308232;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public double getEquatorRadius() {
        return this.a;
    }

    public void setFromMetres(double fromMetres) {
        this.fromMetres = fromMetres;
    }

    public double getFromMetres() {
        return this.fromMetres;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.a = ellipsoid.equatorRadius;
        this.e = ellipsoid.eccentricity;
        this.es = ellipsoid.eccentricity2;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public int getEPSGCode() {
        return 0;
    }

    public void initialize() {
        this.spherical = this.e == 0.0;
        this.one_es = 1.0 - this.es;
        this.rone_es = 1.0 / this.one_es;
        this.totalScale = this.a * this.fromMetres;
        this.totalFalseEasting = this.falseEasting * this.fromMetres;
        this.totalFalseNorthing = this.falseNorthing * this.fromMetres;
    }

    public static float normalizeLongitude(float angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new IllegalArgumentException("Infinite longitude");
        }
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static double normalizeLongitudeRadians(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new IllegalArgumentException("Infinite longitude");
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }
}

