/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Shape2D;
import math.geom2d.ShapeSet2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeArray2D<T extends Shape2D>
implements ShapeSet2D<T>,
Cloneable {
    protected ArrayList<T> shapes;

    public static <T extends Shape2D> ShapeSet2D<T> create(Collection<T> shapes) {
        return new ShapeArray2D<T>(shapes);
    }

    public static <T extends Shape2D> ShapeSet2D<T> create(T[] shapes) {
        return new ShapeArray2D(shapes);
    }

    public ShapeArray2D() {
        this.shapes = new ArrayList();
    }

    public ShapeArray2D(int n) {
        this.shapes = new ArrayList(n);
    }

    public ShapeArray2D(Collection<? extends T> shapes) {
        this.shapes = new ArrayList(shapes.size());
        this.shapes.addAll(shapes);
    }

    public ShapeArray2D(T[] shapes) {
        this.shapes = new ArrayList(shapes.length);
        T[] TArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            T shape = TArray[n2];
            this.shapes.add(shape);
            ++n2;
        }
    }

    public void addShape(T shape) {
        if (!this.shapes.contains(shape)) {
            this.shapes.add(shape);
        }
    }

    public void removeShape(T shape) {
        this.shapes.remove(shape);
    }

    public boolean containsShape(T shape) {
        return this.shapes.contains(shape);
    }

    public void clearShapes() {
        this.shapes.clear();
    }

    public Collection<T> getShapes() {
        return this.shapes;
    }

    public T getShape(int index) {
        return (T)((Shape2D)this.shapes.get(index));
    }

    @Override
    public Shape2D clip(Box2D box) {
        ArrayList<Shape2D> clippedShapes = new ArrayList<Shape2D>();
        for (Shape2D shape : this.shapes) {
            clippedShapes.add(shape.clip(box));
        }
        return new ShapeArray2D(clippedShapes);
    }

    @Override
    public boolean contains(double x, double y) {
        for (Shape2D shape : this.shapes) {
            if (!shape.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public void draw(Graphics2D g2) {
        for (Shape2D shape : this.shapes) {
            shape.draw(g2);
        }
    }

    @Override
    public Box2D getBoundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Shape2D shape : this.shapes) {
            Box2D box = shape.getBoundingBox();
            xmin = Math.min(xmin, box.getMinX());
            ymin = Math.min(ymin, box.getMinY());
            xmax = Math.max(xmax, box.getMaxX());
            ymax = Math.max(ymax, box.getMaxY());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public double getDistance(Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        double dist = Double.POSITIVE_INFINITY;
        for (Shape2D shape : this.shapes) {
            dist = Math.min(dist, shape.getDistance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        for (Shape2D shape : this.shapes) {
            if (shape.isBounded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    @Override
    public ShapeSet2D<? extends Shape2D> transform(AffineTransform2D trans) {
        ShapeArray2D<Shape2D> result = new ShapeArray2D<Shape2D>(this.shapes.size());
        for (Shape2D shape : this.shapes) {
            result.addShape(shape.transform(trans));
        }
        return result;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapeSet2D)) {
            return false;
        }
        ShapeArray2D shapeSet = (ShapeArray2D)obj;
        if (this.shapes.size() != shapeSet.shapes.size()) {
            return false;
        }
        Iterator<T> iter2 = shapeSet.shapes.iterator();
        for (Shape2D shape : this.shapes) {
            if (shape.almostEquals((GeometricObject2D)iter2.next(), eps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.shapes.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapeSet2D)) {
            return false;
        }
        ShapeArray2D shapeSet = (ShapeArray2D)obj;
        if (this.shapes.size() != shapeSet.shapes.size()) {
            return false;
        }
        Iterator<T> iter2 = shapeSet.shapes.iterator();
        for (Shape2D shape : this.shapes) {
            if (shape.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    public ShapeArray2D<? extends Shape2D> clone() {
        ArrayList<Shape2D> array = new ArrayList<Shape2D>(this.shapes.size());
        for (Shape2D shape : this.shapes) {
            array.add(shape);
        }
        return new ShapeArray2D(array);
    }
}

