/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.curve;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import math.geom2d.Point2D;

public final class GeneralPath2D
implements Shape,
Cloneable {
    GeneralPath path;
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;

    public GeneralPath2D() {
        this.path = new GeneralPath();
    }

    public GeneralPath2D(int rule) {
        this.path = new GeneralPath(rule);
    }

    public GeneralPath2D(int rule, int initialCapacity) {
        this.path = new GeneralPath(rule, initialCapacity);
    }

    public GeneralPath2D(Shape s) {
        this.path = new GeneralPath(s);
    }

    public synchronized void moveTo(double x, double y) {
        this.path.moveTo((float)x, (float)y);
    }

    public synchronized void moveTo(java.awt.geom.Point2D p) {
        this.path.moveTo((float)p.getX(), (float)p.getY());
    }

    public synchronized void lineTo(double x, double y) {
        this.path.lineTo((float)x, (float)y);
    }

    public synchronized void lineTo(java.awt.geom.Point2D p) {
        this.path.lineTo((float)p.getX(), (float)p.getY());
    }

    public synchronized void quadTo(double x1, double y1, double x2, double y2) {
        this.path.quadTo((float)x1, (float)y1, (float)x2, (float)y2);
    }

    public synchronized void quadTo(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2) {
        this.path.quadTo((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY());
    }

    public synchronized void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.path.curveTo((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3);
    }

    public synchronized void curveTo(java.awt.geom.Point2D p1, java.awt.geom.Point2D p2, java.awt.geom.Point2D p3) {
        this.path.curveTo((float)p1.getX(), (float)p1.getY(), (float)p2.getX(), (float)p2.getY(), (float)p3.getX(), (float)p3.getY());
    }

    public synchronized void closePath() {
        this.path.closePath();
    }

    public void append(Shape s, boolean connect) {
        this.path.append(s, connect);
    }

    public void append(PathIterator pi, boolean connect) {
        this.path.append(pi, connect);
    }

    public synchronized int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void setWindingRule(int rule) {
        this.path.setWindingRule(rule);
    }

    public synchronized Point2D getCurrentPoint() {
        return new Point2D(this.path.getCurrentPoint());
    }

    public synchronized void reset() {
        this.path.reset();
    }

    public void transform(AffineTransform at) {
        this.path.transform(at);
    }

    public synchronized Shape createTransformedShape(AffineTransform at) {
        return this.path.createTransformedShape(at);
    }

    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    public synchronized Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    public boolean contains(java.awt.geom.Point2D p) {
        return this.path.contains(p);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.path.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeneralPath2D)) {
            return false;
        }
        GeneralPath2D that = (GeneralPath2D)obj;
        return this.path.equals(that.path);
    }

    public Object clone() {
        return this.path.clone();
    }
}

