/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.ShapeArray2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.DomainSet2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainArray2D<T extends Domain2D>
extends ShapeArray2D<T>
implements DomainSet2D<T> {
    public static <D extends Domain2D> DomainArray2D<D> create(Collection<D> array) {
        return new DomainArray2D<D>(array);
    }

    public static <D extends Domain2D> DomainArray2D<D> create(D[] array) {
        return new DomainArray2D(array);
    }

    public DomainArray2D() {
    }

    public DomainArray2D(int n) {
        super(n);
    }

    public DomainArray2D(Collection<T> domains) {
        super(domains);
    }

    public DomainArray2D(T[] domains) {
        super(domains);
    }

    @Override
    public DomainSet2D<? extends Domain2D> complement() {
        int n = this.shapes.size();
        ArrayList<Domain2D> complements = new ArrayList<Domain2D>(n);
        for (Domain2D domain : this) {
            complements.add(domain.complement());
        }
        return new DomainArray2D(complements);
    }

    @Override
    public void fill(Graphics2D g2) {
        for (Domain2D domain : this) {
            domain.fill(g2);
        }
    }

    @Override
    public Boundary2D getBoundary() {
        int n = this.shapes.size();
        ArrayList<? extends Contour2D> boundaries = new ArrayList<Contour2D>(n);
        for (Domain2D domain : this) {
            boundaries.addAll(domain.getBoundary().getContinuousCurves());
        }
        return new ContourArray2D(boundaries);
    }

    @Override
    public DomainArray2D<? extends Domain2D> transform(AffineTransform2D trans) {
        DomainArray2D<Domain2D> result = new DomainArray2D<Domain2D>(this.shapes.size());
        for (Domain2D domain : this) {
            result.addShape(domain.transform(trans));
        }
        return result;
    }

    @Override
    public Domain2D clip(Box2D box) {
        ArrayList<Domain2D> clippedShapes = new ArrayList<Domain2D>();
        for (Domain2D domain : this) {
            clippedShapes.add(domain.clip(box));
        }
        return new DomainArray2D(clippedShapes);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DomainArray2D)) {
            return false;
        }
        return super.equals(obj);
    }
}

