/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.OrientedCurve2D;
import math.geom2d.line.StraightLine2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyOrientedCurve2D<T extends ContinuousOrientedCurve2D>
extends PolyCurve2D<T>
implements ContinuousOrientedCurve2D {
    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(Collection<T> curves) {
        return new PolyOrientedCurve2D<T>(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(T[] curves) {
        return new PolyOrientedCurve2D(curves);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(Collection<T> curves, boolean closed) {
        return new PolyOrientedCurve2D<T>(curves, closed);
    }

    public static <T extends ContinuousOrientedCurve2D> PolyOrientedCurve2D<T> create(T[] curves, boolean closed) {
        return new PolyOrientedCurve2D(curves, closed);
    }

    public PolyOrientedCurve2D() {
    }

    public PolyOrientedCurve2D(int size) {
        super(size);
    }

    public PolyOrientedCurve2D(T[] curves) {
        super(curves);
    }

    public PolyOrientedCurve2D(T[] curves, boolean closed) {
        super(curves, closed);
    }

    public PolyOrientedCurve2D(Collection<? extends T> curves) {
        super(curves);
    }

    public PolyOrientedCurve2D(Collection<? extends T> curves, boolean closed) {
        super(curves, closed);
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        double angle = 0.0;
        for (OrientedCurve2D curve : this.curves) {
            angle += curve.getWindingAngle(point);
        }
        return angle;
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D p) {
        return this.getSignedDistance(p.getX(), p.getY());
    }

    @Override
    public double getSignedDistance(double x, double y) {
        double dist = this.getDistance(x, y);
        if (this.isInside(new Point2D(x, y))) {
            dist = -dist;
        }
        return dist;
    }

    private static Vector2D getTangent(ContinuousCurve2D curve, double pos) {
        if (curve instanceof SmoothCurve2D) {
            return ((SmoothCurve2D)curve).getTangent(pos);
        }
        if (curve instanceof CurveSet2D) {
            CurveSet2D curveSet = (CurveSet2D)((Object)curve);
            double pos2 = curveSet.getLocalPosition(pos);
            Object subCurve = curveSet.getChildCurve(pos);
            return PolyOrientedCurve2D.getTangent((ContinuousCurve2D)subCurve, pos2);
        }
        System.err.println("Unknown type of curve: should be either continuous or curveset");
        return null;
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D point) {
        double pos = this.project(point);
        if (this.isSingular(pos)) {
            int n = this.getCurveNumber();
            int i = this.getCurveIndex(pos);
            if (pos / 2.0 - (double)i > 0.25) {
                ++i;
            }
            if (Math.round(pos) == (long)(2 * n - 1)) {
                pos = 0.0;
                i = 0;
            }
            Point2D vertex = this.getPoint(2.0 * pos);
            int iPrev = i > 0 ? i - 1 : n - 1;
            int iNext = i;
            ContinuousOrientedCurve2D prev = (ContinuousOrientedCurve2D)this.curves.get(iPrev);
            ContinuousOrientedCurve2D next = (ContinuousOrientedCurve2D)this.curves.get(iNext);
            Vector2D v1 = PolyOrientedCurve2D.getTangent(prev, prev.getT1());
            Vector2D v2 = PolyOrientedCurve2D.getTangent(next, next.getT0());
            boolean in1 = new StraightLine2D((java.awt.geom.Point2D)vertex, v1).isInside(point);
            boolean in2 = new StraightLine2D((java.awt.geom.Point2D)vertex, v2).isInside(point);
            if (Angle2D.getAngle(v1, v2) < Math.PI) {
                return in1 && in2;
            }
            return in1 || in2;
        }
        return ((ContinuousOrientedCurve2D)this.getChildCurve(pos)).isInside(point);
    }

    @Override
    public PolyOrientedCurve2D<? extends ContinuousOrientedCurve2D> getReverseCurve() {
        ContinuousOrientedCurve2D[] curves2 = new ContinuousOrientedCurve2D[this.curves.size()];
        int n = this.curves.size();
        int i = 0;
        while (i < n) {
            curves2[i] = ((ContinuousOrientedCurve2D)this.curves.get(n - 1 - i)).getReverseCurve();
            ++i;
        }
        return new PolyOrientedCurve2D(curves2);
    }

    @Override
    public PolyOrientedCurve2D<? extends ContinuousOrientedCurve2D> getSubCurve(double t0, double t1) {
        Curve2D set = super.getSubCurve(t0, t1);
        PolyOrientedCurve2D<ContinuousOrientedCurve2D> subCurve = new PolyOrientedCurve2D<ContinuousOrientedCurve2D>();
        subCurve.setClosed(false);
        for (Curve2D curve : ((CurveArray2D)set).getCurves()) {
            subCurve.addCurve((ContinuousOrientedCurve2D)curve);
        }
        return subCurve;
    }

    @Override
    public CurveSet2D<? extends ContinuousOrientedCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        int n = set.getCurveNumber();
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>(n);
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof ContinuousOrientedCurve2D)) continue;
            result.addCurve((ContinuousOrientedCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyOrientedCurve2D<?> transform(AffineTransform2D trans) {
        PolyOrientedCurve2D<ContinuousOrientedCurve2D> result = new PolyOrientedCurve2D<ContinuousOrientedCurve2D>();
        for (ContinuousOrientedCurve2D curve : this.curves) {
            result.addCurve(curve.transform(trans));
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CurveSet2D)) {
            return false;
        }
        return super.equals(obj);
    }
}

