/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.line;

import java.awt.geom.GeneralPath;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.StraightLine2D;

public class LineSegment2D
extends AbstractLine2D
implements Cloneable,
CirculinearElement2D {
    public static LineSegment2D create(Point2D p1, Point2D p2) {
        return new LineSegment2D((java.awt.geom.Point2D)p1, p2);
    }

    public static StraightLine2D getMedian(LineSegment2D edge) {
        return new StraightLine2D(edge.x0 + edge.dx * 0.5, edge.y0 + edge.dy * 0.5, -edge.dy, edge.dx);
    }

    public static double getEdgeAngle(LineSegment2D edge1, LineSegment2D edge2) {
        double y2;
        double x2;
        double y1;
        double x1;
        double y0;
        double x0;
        if (Math.abs(edge1.x0 - edge2.x0) < 1.0E-12 && Math.abs(edge1.y0 - edge2.y0) < 1.0E-12) {
            x0 = edge1.x0;
            y0 = edge1.y0;
            x1 = edge1.x0 + edge1.dx;
            y1 = edge1.y0 + edge1.dy;
            x2 = edge2.x0 + edge2.dx;
            y2 = edge2.y0 + edge2.dy;
        } else if (Math.abs(edge1.x0 + edge1.dx - edge2.x0) < 1.0E-12 && Math.abs(edge1.y0 + edge1.dy - edge2.y0) < 1.0E-12) {
            x0 = edge1.x0 + edge1.dx;
            y0 = edge1.y0 + edge1.dy;
            x1 = edge1.x0;
            y1 = edge1.y0;
            x2 = edge2.x0 + edge2.dx;
            y2 = edge2.y0 + edge2.dy;
        } else if (Math.abs(edge1.x0 + edge1.dx - edge2.x0 - edge2.dx) < 1.0E-12 && Math.abs(edge1.y0 + edge1.dy - edge2.y0 - edge2.dy) < 1.0E-12) {
            x0 = edge1.x0 + edge1.dx;
            y0 = edge1.y0 + edge1.dy;
            x1 = edge1.x0;
            y1 = edge1.y0;
            x2 = edge2.x0;
            y2 = edge2.y0;
        } else if (Math.abs(edge1.x0 - edge2.x0 - edge2.dx) < 1.0E-12 && Math.abs(edge1.y0 - edge2.y0 - edge2.dy) < 1.0E-12) {
            x0 = edge1.x0;
            y0 = edge1.y0;
            x1 = edge1.x0 + edge1.dx;
            y1 = edge1.y0 + edge1.dy;
            x2 = edge2.x0;
            y2 = edge2.y0;
        } else {
            return Double.NaN;
        }
        return Angle2D.getAngle(new Vector2D(x1 - x0, y1 - y0), new Vector2D(x2 - x0, y2 - y0));
    }

    public static boolean intersects(LineSegment2D edge1, LineSegment2D edge2) {
        boolean b2;
        Point2D e1p1 = edge1.getFirstPoint();
        Point2D e1p2 = edge1.getLastPoint();
        Point2D e2p1 = edge2.getFirstPoint();
        Point2D e2p2 = edge2.getLastPoint();
        boolean b1 = Point2D.ccw(e1p1, e1p2, e2p1) * Point2D.ccw(e1p1, e1p2, e2p2) <= 0;
        boolean bl = b2 = Point2D.ccw(e2p1, e2p2, e1p1) * Point2D.ccw(e2p1, e2p2, e1p2) <= 0;
        return b1 && b2;
    }

    public LineSegment2D(java.awt.geom.Point2D point1, java.awt.geom.Point2D point2) {
        this(point1.getX(), point1.getY(), point2.getX(), point2.getY());
    }

    public LineSegment2D(double x1, double y1, double x2, double y2) {
        super(x1, y1, x2 - x1, y2 - y1);
    }

    public Point2D getOtherPoint(Point2D point) {
        if (point.equals(new Point2D(this.x0, this.y0))) {
            return new Point2D(this.x0 + this.dx, this.y0 + this.dy);
        }
        if (point.equals(new Point2D(this.x0 + this.dx, this.y0 + this.dy))) {
            return new Point2D(this.x0, this.y0);
        }
        return null;
    }

    public StraightLine2D getMedian() {
        return new StraightLine2D(this.x0 + this.dx * 0.5, this.y0 + this.dy * 0.5, -this.dy, this.dx);
    }

    public double getLength() {
        return Math.hypot(this.dx, this.dy);
    }

    public LineSegment2D getParallel(double d) {
        double dd = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        return new LineSegment2D(this.x0 + this.dy * d / dd, this.y0 - this.dx * d / dd, this.x0 + this.dx + this.dy * d / dd, this.y0 + this.dy - this.dx * d / dd);
    }

    public double getSignedDistance(double x, double y) {
        Point2D proj = super.getProjectedPoint(x, y);
        if (this.contains(proj)) {
            return super.getSignedDistance(x, y);
        }
        double d = this.getDistance(x, y);
        return super.getSignedDistance(x, y) > 0.0 ? d : -d;
    }

    public Point2D getFirstPoint() {
        return new Point2D(this.x0, this.y0);
    }

    public Point2D getLastPoint() {
        return new Point2D(this.x0 + this.dx, this.y0 + this.dy);
    }

    public double getT0() {
        return 0.0;
    }

    public double getT1() {
        return 1.0;
    }

    public Point2D getPoint(double t) {
        t = Math.min(Math.max(t, 0.0), 1.0);
        return new Point2D(this.x0 + this.dx * t, this.y0 + this.dy * t);
    }

    public LineSegment2D getReverseCurve() {
        return new LineSegment2D(this.x0 + this.dx, this.y0 + this.dy, this.x0, this.y0);
    }

    public boolean isBounded() {
        return true;
    }

    public boolean contains(double xp, double yp) {
        if (!super.supportContains(xp, yp)) {
            return false;
        }
        double t = this.getPositionOnLine(xp, yp);
        if (t < -1.0E-12) {
            return false;
        }
        return !(t - 1.0 > 1.0E-12);
    }

    public double getDistance(double x, double y) {
        Point2D proj = super.getProjectedPoint(x, y);
        if (this.contains(proj)) {
            return proj.distance(x, y);
        }
        double d1 = Math.hypot(this.x0 - x, this.y0 - y);
        double d2 = Math.hypot(this.x0 + this.dx - x, this.y0 + this.dy - y);
        return Math.min(d1, d2);
    }

    public LineSegment2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        double x1 = this.x0 * tab[0] + this.y0 * tab[1] + tab[2];
        double y1 = this.x0 * tab[3] + this.y0 * tab[4] + tab[5];
        double x2 = (this.x0 + this.dx) * tab[0] + (this.y0 + this.dy) * tab[1] + tab[2];
        double y2 = (this.x0 + this.dx) * tab[3] + (this.y0 + this.dy) * tab[4] + tab[5];
        return new LineSegment2D(x1, y1, x2, y2);
    }

    public Box2D getBoundingBox() {
        return new Box2D(this.x0, this.x0 + this.dx, this.y0, this.y0 + this.dy);
    }

    public GeneralPath appendPath(GeneralPath path) {
        path.lineTo((double)((float)this.x0) + this.dx, (double)((float)this.y0) + this.dy);
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        path.moveTo((float)this.x0, (float)this.y0);
        path.lineTo((float)(this.x0 + this.dx), (float)(this.y0 + this.dy));
        return path;
    }

    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment2D)) {
            return false;
        }
        LineSegment2D edge = (LineSegment2D)obj;
        if (Math.abs(this.x0 - edge.x0) > eps) {
            return false;
        }
        if (Math.abs(this.y0 - edge.y0) > eps) {
            return false;
        }
        if (Math.abs(this.dx - edge.dx) > eps) {
            return false;
        }
        return !(Math.abs(this.dy - edge.dy) > eps);
    }

    public String toString() {
        return new String("LineSegment2D[(" + this.x0 + "," + this.y0 + ")-(" + (this.x0 + this.dx) + "," + (this.y0 + this.dy) + ")]");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineSegment2D)) {
            return false;
        }
        LineSegment2D edge = (LineSegment2D)obj;
        if (Math.abs(this.x0 - edge.x0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y0 - edge.y0) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.dx - edge.dx) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.dy - edge.dy) > 1.0E-12);
    }

    public LineSegment2D clone() {
        return new LineSegment2D(this.x0, this.y0, this.x0 + this.dx, this.y0 + this.dy);
    }
}

