/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.point;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearShape2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.point.PointSet2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointArray2D
implements PointSet2D,
CirculinearShape2D,
Cloneable {
    protected ArrayList<Point2D> points = new ArrayList();

    public static <T extends java.awt.geom.Point2D> PointArray2D create(Collection<T> points) {
        return new PointArray2D(points);
    }

    public static <T extends java.awt.geom.Point2D> PointArray2D create(T[] points) {
        return new PointArray2D((java.awt.geom.Point2D[])points);
    }

    public static PointArray2D create(int size) {
        return new PointArray2D(size);
    }

    public PointArray2D() {
        this(0);
    }

    public PointArray2D(int n) {
    }

    public PointArray2D(java.awt.geom.Point2D[] points) {
        this(points.length);
        java.awt.geom.Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            java.awt.geom.Point2D element = point2DArray[n2];
            if (Point2D.class.isInstance(element)) {
                this.points.add((Point2D)element);
            } else {
                this.points.add(new Point2D(element));
            }
            ++n2;
        }
    }

    public PointArray2D(Collection<? extends java.awt.geom.Point2D> points) {
        this(points.size());
        for (java.awt.geom.Point2D point2D : points) {
            if (point2D instanceof Point2D) {
                this.points.add((Point2D)point2D);
                continue;
            }
            this.points.add(new Point2D(point2D));
        }
    }

    @Override
    public void addPoint(java.awt.geom.Point2D point) {
        if (point instanceof Point2D) {
            this.points.add((Point2D)point);
        } else {
            this.points.add(new Point2D(point));
        }
    }

    public void addPoints(java.awt.geom.Point2D[] points) {
        java.awt.geom.Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            java.awt.geom.Point2D element = point2DArray[n2];
            this.addPoint(element);
            ++n2;
        }
    }

    @Override
    public void addPoints(Collection<? extends Point2D> points) {
        this.points.addAll(points);
    }

    @Override
    public Collection<Point2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public void clearPoints() {
        this.points.clear();
    }

    @Override
    public int getPointNumber() {
        return this.points.size();
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public PointArray2D transform(CircleInversion2D inv) {
        PointArray2D array = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            array.addPoint(point.transform(inv));
        }
        return array;
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return this.getDistance(p.getX(), p.getY());
    }

    @Override
    public double getDistance(double x, double y) {
        if (this.points.isEmpty()) {
            return Double.NaN;
        }
        double dist = Double.MAX_VALUE;
        for (Point2D point : this.points) {
            dist = Math.min(dist, point.getDistance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public PointArray2D clip(Box2D box) {
        PointArray2D res = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            if (!box.contains(point)) continue;
            res.addPoint(point);
        }
        res.points.trimToSize();
        return res;
    }

    @Override
    public Box2D getBoundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Point2D point : this.points) {
            xmin = Math.min(xmin, point.getX());
            ymin = Math.min(ymin, point.getY());
            xmax = Math.max(xmax, point.getX());
            ymax = Math.max(ymax, point.getY());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public PointArray2D transform(AffineTransform2D trans) {
        PointArray2D res = new PointArray2D(this.points.size());
        for (Point2D point : this.points) {
            res.addPoint(point.transform(trans));
        }
        return res;
    }

    @Override
    public boolean contains(double x, double y) {
        for (Point2D point : this.points) {
            if (!(point.getDistance(x, y) < 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(java.awt.geom.Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public void draw(Graphics2D g2) {
        this.draw(g2, 1.0);
    }

    public void draw(Graphics2D g2, double r) {
        double w = 2.0 * r;
        for (Point2D point : this.points) {
            double x = point.getX();
            double y = point.getY();
            g2.fill(new Ellipse2D.Double(x - r, y - r, w, w));
        }
    }

    @Override
    public Iterator<Point2D> iterator() {
        return this.points.iterator();
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointSet2D)) {
            return false;
        }
        PointSet2D set = (PointSet2D)obj;
        if (this.points.size() != set.getPointNumber()) {
            return false;
        }
        Iterator iter = set.iterator();
        for (Point2D point : this.points) {
            if (point.almostEquals((GeometricObject2D)iter.next(), eps)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PointSet2D)) {
            return false;
        }
        PointSet2D set = (PointSet2D)obj;
        if (this.points.size() != set.getPointNumber()) {
            return false;
        }
        Iterator iter = set.iterator();
        for (Point2D point : this.points) {
            if (point.equals(iter.next())) continue;
            return false;
        }
        return true;
    }

    public PointArray2D clone() {
        PointArray2D set = new PointArray2D(this.getPointNumber());
        for (Point2D point : this) {
            set.addPoint(point.clone());
        }
        return set;
    }
}

