/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContourArray2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.polygon.Polygon2D;
import math.geom2d.polygon.Polygon2DUtils;
import math.geom2d.polygon.Polyline2D;
import math.geom2d.polygon.SimplePolygon2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiPolygon2D
implements Domain2D,
Polygon2D {
    ArrayList<LinearRing2D> rings = new ArrayList();

    public static MultiPolygon2D create(Collection<LinearRing2D> rings) {
        return new MultiPolygon2D(rings);
    }

    public static MultiPolygon2D create(LinearRing2D[] rings) {
        return new MultiPolygon2D(rings);
    }

    public MultiPolygon2D() {
    }

    public MultiPolygon2D(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public MultiPolygon2D(LinearRing2D[] rings) {
        LinearRing2D[] linearRing2DArray = rings;
        int n = rings.length;
        int n2 = 0;
        while (n2 < n) {
            LinearRing2D ring = linearRing2DArray[n2];
            this.rings.add(ring);
            ++n2;
        }
    }

    public MultiPolygon2D(SimplePolygon2D polygon) {
        this.rings.addAll(((CurveArray2D)((Object)polygon.getBoundary())).getCurves());
    }

    public MultiPolygon2D(Collection<LinearRing2D> lines) {
        this.rings.addAll(lines);
    }

    @Deprecated
    public void addPolygon(SimplePolygon2D polygon) {
        this.rings.addAll(polygon.getRings());
    }

    @Deprecated
    public Collection<SimplePolygon2D> getPolygons() {
        ArrayList<SimplePolygon2D> polygons = new ArrayList<SimplePolygon2D>();
        for (LinearRing2D ring : this.rings) {
            polygons.add(new SimplePolygon2D(ring.getVertices()));
        }
        return polygons;
    }

    public void addRing(LinearRing2D ring) {
        this.rings.add(ring);
    }

    public void removeRing(LinearRing2D ring) {
        this.rings.remove(ring);
    }

    public int getRingNumber() {
        return this.rings.size();
    }

    @Override
    public double getArea() {
        return Math.abs(this.getSignedArea());
    }

    @Override
    public double getSignedArea() {
        return Polygon2DUtils.computeSignedArea(this);
    }

    @Override
    public Point2D getCentroid() {
        return Polygon2DUtils.computeCentroid(this);
    }

    public Collection<LinearRing2D> getRings() {
        return Collections.unmodifiableList(this.rings);
    }

    @Override
    public CirculinearDomain2D transform(CircleInversion2D inv) {
        return new GenericCirculinearDomain2D((CirculinearBoundary2D)((CirculinearContourArray2D)this.getBoundary()).transform(inv));
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        return Polygon2DUtils.createBuffer(this, dist);
    }

    @Override
    public CirculinearContourArray2D<LinearRing2D> getBoundary() {
        return CirculinearContourArray2D.create(this.rings);
    }

    @Override
    public Polygon2D complement() {
        ArrayList<LinearRing2D> reverseLines = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            reverseLines.add(ring.getReverseCurve());
        }
        return new MultiPolygon2D(reverseLines);
    }

    public Collection<LineSegment2D> getEdges() {
        int nEdges = this.getEdgeNumber();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(nEdges);
        for (LinearRing2D ring : this.rings) {
            edges.addAll(ring.getEdges());
        }
        return edges;
    }

    @Override
    public int getEdgeNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.getVertexNumber();
        }
        return count;
    }

    @Override
    public Collection<Point2D> getVertices() {
        int nv = this.getVertexNumber();
        ArrayList<Point2D> points = new ArrayList<Point2D>(nv);
        for (LinearRing2D ring : this.rings) {
            points.addAll(ring.getVertices());
        }
        return points;
    }

    @Override
    public Point2D getVertex(int i) {
        int count = 0;
        Polyline2D boundary = null;
        for (LinearRing2D ring : this.rings) {
            int nv = ring.getVertexNumber();
            if (count + nv > i) {
                boundary = ring;
                break;
            }
            count += nv;
        }
        if (boundary == null) {
            throw new IndexOutOfBoundsException();
        }
        return boundary.getVertex(i - count);
    }

    @Override
    public int getVertexNumber() {
        int count = 0;
        for (LinearRing2D ring : this.rings) {
            count += ring.getVertexNumber();
        }
        return count;
    }

    @Override
    public Box2D getBoundingBox() {
        Box2D box = new Box2D(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (LinearRing2D ring : this.rings) {
            box = box.union(ring.getBoundingBox());
        }
        return box;
    }

    @Override
    public Polygon2D clip(Box2D box) {
        return Polygon2DUtils.clipPolygon(this, box);
    }

    @Override
    public double getDistance(java.awt.geom.Point2D p) {
        return Math.max(((ContourArray2D)((Object)this.getBoundary())).getSignedDistance(p), 0.0);
    }

    @Override
    public double getDistance(double x, double y) {
        return Math.max(((ContourArray2D)((Object)this.getBoundary())).getSignedDistance(x, y), 0.0);
    }

    @Override
    public boolean isBounded() {
        CirculinearBoundary2D boundary = this.getBoundary();
        if (!boundary.isBounded()) {
            return false;
        }
        double area = 0.0;
        for (LinearRing2D ring : this.rings) {
            area += ring.getSignedArea();
        }
        return area > 0.0;
    }

    @Override
    public boolean isEmpty() {
        for (LinearRing2D ring : this.rings) {
            if (ring.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public MultiPolygon2D transform(AffineTransform2D trans) {
        ArrayList<LinearRing2D> transformed = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            transformed.add(ring.transform(trans));
        }
        return new MultiPolygon2D(transformed);
    }

    @Override
    public boolean contains(java.awt.geom.Point2D point) {
        double angle = 0.0;
        for (LinearRing2D ring : this.rings) {
            angle += ring.getWindingAngle(point);
        }
        double area = this.getSignedArea();
        if (area > 0.0) {
            return angle > Math.PI;
        }
        return angle > -Math.PI;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D(x, y));
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    @Override
    public void fill(Graphics2D g) {
        g.fill(((CurveArray2D)((Object)this.getBoundary())).getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiPolygon2D)) {
            return false;
        }
        MultiPolygon2D polygon = (MultiPolygon2D)obj;
        if (polygon.rings.size() != this.rings.size()) {
            return false;
        }
        int i = 0;
        while (i < this.rings.size()) {
            if (!this.rings.get(i).almostEquals(polygon.rings.get(i), eps)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MultiPolygon2D)) {
            return false;
        }
        MultiPolygon2D polygon = (MultiPolygon2D)obj;
        if (polygon.rings.size() != this.rings.size()) {
            return false;
        }
        int i = 0;
        while (i < this.rings.size()) {
            if (!this.rings.get(i).equals(polygon.rings.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public MultiPolygon2D clone() {
        ArrayList<LinearRing2D> array = new ArrayList<LinearRing2D>(this.rings.size());
        for (LinearRing2D ring : this.rings) {
            array.add(ring.clone());
        }
        return new MultiPolygon2D(array);
    }
}

