/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.polygon;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.CirculinearElement2D;
import math.geom2d.circulinear.PolyCirculinearCurve2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.AbstractContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.line.AbstractLine2D;
import math.geom2d.line.LineSegment2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.geom2d.point.PointSet2DUtils;
import math.geom2d.polygon.LinearRing2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polyline2D
extends AbstractContinuousCurve2D
implements CirculinearContinuousCurve2D,
Cloneable {
    protected ArrayList<Point2D> points = new ArrayList();

    public static Polyline2D create(Collection<? extends Point2D> points) {
        return new Polyline2D(points);
    }

    public static Polyline2D create(Point2D[] points) {
        return new Polyline2D(points);
    }

    public Polyline2D() {
    }

    public Polyline2D(Point2D initialPoint) {
        this.points.add(initialPoint);
    }

    public Polyline2D(Point2D[] points) {
        Point2D[] point2DArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D element = point2DArray[n2];
            this.points.add(element);
            ++n2;
        }
    }

    public Polyline2D(Collection<? extends Point2D> points) {
        this.points.addAll(points);
    }

    public Polyline2D(double[] xcoords, double[] ycoords) {
        int i = 0;
        while (i < xcoords.length) {
            this.points.add(new Point2D(xcoords[i], ycoords[i]));
            ++i;
        }
    }

    public Iterator<Point2D> getPointsIterator() {
        return this.points.iterator();
    }

    public Point2D[] getPointArray() {
        Point2D[] tab = new Point2D[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            tab[i] = this.points.get(i);
            ++i;
        }
        return tab;
    }

    public void addPoint(Point2D point) {
        this.points.add(point);
    }

    public void removePoint(Point2D point) {
        this.points.remove(point);
    }

    @Deprecated
    public void clearPoints() {
        this.points.clear();
    }

    public void clearVertices() {
        this.points.clear();
    }

    @Override
    public Collection<Point2D> getVertices() {
        return this.points;
    }

    public Point2D getVertex(int i) {
        return this.points.get(i);
    }

    public int getVertexNumber() {
        return this.points.size();
    }

    public Collection<LineSegment2D> getEdges() {
        int n = this.points.size();
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(n);
        if (n < 2) {
            return edges;
        }
        int i = 0;
        while (i < n - 1) {
            edges.add(new LineSegment2D((java.awt.geom.Point2D)this.points.get(i), this.points.get(i + 1)));
            ++i;
        }
        return edges;
    }

    public LineSegment2D getEdge(int index) {
        return new LineSegment2D((java.awt.geom.Point2D)this.points.get(index), this.points.get(index + 1));
    }

    public LineSegment2D getFirstEdge() {
        if (this.points.size() < 2) {
            return null;
        }
        return new LineSegment2D((java.awt.geom.Point2D)this.points.get(0), this.points.get(1));
    }

    public LineSegment2D getLastEdge() {
        int n = this.points.size();
        if (n < 2) {
            return null;
        }
        return new LineSegment2D((java.awt.geom.Point2D)this.points.get(n - 2), this.points.get(n - 1));
    }

    @Override
    public double getLength() {
        double sum = 0.0;
        for (LineSegment2D edge : this.getEdges()) {
            sum += edge.getLength();
        }
        return sum;
    }

    @Override
    public double getLength(double pos) {
        double length = 0.0;
        int index = (int)Math.floor(pos);
        int i = 0;
        while (i < index) {
            length += this.getEdge(i).getLength();
            ++i;
        }
        if (index < this.points.size() - 1) {
            double pos2 = pos - (double)index;
            length += this.getEdge(index).getLength(pos2);
        }
        return length;
    }

    @Override
    public double getPosition(double length) {
        double pos = 0.0;
        int index = 0;
        double cumLength = this.getLength(this.getT0());
        for (LineSegment2D edge : this.getEdges()) {
            double edgeLength = edge.getLength();
            if (cumLength + edgeLength < length) {
                cumLength += edgeLength;
                ++index;
                continue;
            }
            double pos2 = edge.getPosition(length - cumLength);
            pos = (double)index + pos2;
            break;
        }
        return pos;
    }

    @Override
    public CirculinearDomain2D getBuffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        if (PointSet2DUtils.hasMultipleVertices(this.points)) {
            Polyline2D poly2 = Polyline2D.create(PointSet2DUtils.filterMultipleVertices(this.points));
            return bc.computeBuffer(poly2, dist);
        }
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearContinuousCurve2D getParallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createContinuousParallel(this, d);
    }

    @Override
    public CirculinearContinuousCurve2D transform(CircleInversion2D inv) {
        Collection<LineSegment2D> edges = this.getEdges();
        ArrayList<CirculinearElement2D> arcs = new ArrayList<CirculinearElement2D>(edges.size());
        for (LineSegment2D edge : edges) {
            arcs.add(edge.transform(inv));
        }
        return new PolyCirculinearCurve2D(arcs);
    }

    @Override
    public Vector2D getLeftTangent(double t) {
        int index = (int)Math.floor(t);
        if (Math.abs(t - (double)index) < 1.0E-12) {
            --index;
        }
        return this.getEdge(index).getTangent(0.0);
    }

    @Override
    public Vector2D getRightTangent(double t) {
        int index = (int)Math.ceil(t);
        return this.getEdge(index).getTangent(0.0);
    }

    @Override
    public double getSignedDistance(double x, double y) {
        double dist = this.getDistance(x, y);
        if (this.isInside(new Point2D(x, y))) {
            return -dist;
        }
        return dist;
    }

    @Override
    public double getSignedDistance(java.awt.geom.Point2D point) {
        double dist = this.getDistance(point.getX(), point.getY());
        if (this.isInside(point)) {
            return -dist;
        }
        return dist;
    }

    @Override
    public double getWindingAngle(java.awt.geom.Point2D point) {
        double angle = 0.0;
        int n = this.points.size();
        int i = 0;
        while (i < n - 1) {
            angle += new LineSegment2D((java.awt.geom.Point2D)this.points.get(i), this.points.get(i + 1)).getWindingAngle(point);
            ++i;
        }
        return angle;
    }

    @Override
    public boolean isInside(java.awt.geom.Point2D pt) {
        Point2D q1;
        if (new LinearRing2D(this.getPointArray()).isInside(pt)) {
            return true;
        }
        if (this.points.size() < 3) {
            return false;
        }
        Point2D p0 = this.getFirstPoint();
        Point2D q0 = this.points.get(1);
        if (new StraightLine2D((java.awt.geom.Point2D)q0, (java.awt.geom.Point2D)p0).isInside(pt)) {
            return false;
        }
        Point2D p1 = this.getLastPoint();
        if (new StraightLine2D((java.awt.geom.Point2D)p1, (java.awt.geom.Point2D)(q1 = this.points.get(this.points.size() - 2))).isInside(pt)) {
            return false;
        }
        return new StraightLine2D((java.awt.geom.Point2D)p0, (java.awt.geom.Point2D)p1).isInside(pt);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public Collection<? extends LineSegment2D> getSmoothPieces() {
        return this.getEdges();
    }

    @Override
    public Collection<Point2D> getIntersections(LinearShape2D line) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (LineSegment2D edge : this.getEdges()) {
            Point2D point = edge.getIntersection(line);
            if (point == null || list.contains(point)) continue;
            list.add(point);
        }
        return list;
    }

    @Override
    public Point2D getPoint(double t) {
        double t0 = this.getT0();
        double t1 = this.getT1();
        t = Math.max(Math.min(t, t1), t0);
        int ind0 = (int)Math.floor(t + 1.0E-12);
        double tl = t - (double)ind0;
        Point2D p0 = this.points.get(ind0);
        if (Math.abs(t - (double)ind0) < 1.0E-12) {
            return new Point2D(p0);
        }
        int ind1 = ind0 + 1;
        Point2D p1 = this.points.get(ind1);
        double x0 = p0.getX();
        double y0 = p0.getY();
        double dx = p1.getX() - x0;
        double dy = p1.getY() - y0;
        return new Point2D(x0 + tl * dx, y0 + tl * dy);
    }

    @Override
    public double getPosition(java.awt.geom.Point2D point) {
        int ind = 0;
        double minDist = Double.POSITIVE_INFINITY;
        double x = point.getX();
        double y = point.getY();
        int i = 0;
        AbstractLine2D closest = null;
        for (LineSegment2D edge : this.getEdges()) {
            double dist = edge.getDistance(x, y);
            if (dist < minDist) {
                minDist = dist;
                ind = i;
                closest = edge;
            }
            ++i;
        }
        return closest.getPosition(point) + (double)ind;
    }

    @Override
    public double project(java.awt.geom.Point2D point) {
        double minDist = Double.POSITIVE_INFINITY;
        double x = point.getX();
        double y = point.getY();
        double pos = Double.NaN;
        int i = 0;
        for (LineSegment2D edge : this.getEdges()) {
            double dist = edge.getDistance(x, y);
            if (dist < minDist) {
                minDist = dist;
                pos = edge.project(point) + (double)i;
            }
            ++i;
        }
        return pos;
    }

    @Override
    public double getT0() {
        return 0.0;
    }

    @Override
    public double getT1() {
        return this.points.size() - 1;
    }

    @Override
    public Point2D getFirstPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return this.points.get(0);
    }

    @Override
    public Point2D getLastPoint() {
        if (this.points.size() == 0) {
            return null;
        }
        return this.points.get(this.points.size() - 1);
    }

    @Override
    public Collection<Point2D> getSingularPoints() {
        return this.points;
    }

    @Override
    public boolean isSingular(double pos) {
        return Math.abs(pos - (double)Math.round(pos)) < 1.0E-12;
    }

    @Override
    public Polyline2D getReverseCurve() {
        Point2D[] points2 = new Point2D[this.points.size()];
        int n = this.points.size();
        if (n > 0) {
            int i = 0;
            while (i < n) {
                points2[i] = this.points.get(n - 1 - i);
                ++i;
            }
        }
        return new Polyline2D(points2);
    }

    public Collection<? extends Polyline2D> getContinuousCurves() {
        return Polyline2D.wrapCurve(this);
    }

    @Override
    public Polyline2D getSubCurve(double t0, double t1) {
        int ind1;
        Polyline2D res = new Polyline2D();
        if (t1 < t0) {
            return res;
        }
        int indMax = (int)this.getT1();
        t0 = Math.min(Math.max(t0, 0.0), (double)indMax);
        t1 = Math.min(Math.max(t1, 0.0), (double)indMax);
        int ind0 = (int)Math.floor(t0);
        if (ind0 == (ind1 = (int)Math.floor(t1))) {
            res.addPoint(this.getPoint(t0));
            res.addPoint(this.getPoint(t1));
            return res;
        }
        res.addPoint(this.getPoint(t0));
        int n = ind0 + 1;
        while (n <= ind1) {
            res.addPoint(this.points.get(n));
            ++n;
        }
        res.addPoint(this.getPoint(t1));
        return res;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.points.size() == 0;
    }

    @Override
    public CurveSet2D<? extends Polyline2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        CurveArray2D<Polyline2D> result = new CurveArray2D<Polyline2D>(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof Polyline2D)) continue;
            result.addCurve((Polyline2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D getBoundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Point2D point : this.points) {
            double x = point.getX();
            double y = point.getY();
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
            ymin = Math.min(ymin, y);
            ymax = Math.max(ymax, y);
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public double getDistance(double x, double y) {
        double dist = Double.MAX_VALUE;
        for (LineSegment2D edge : this.getEdges()) {
            if (edge.getLength() == 0.0) continue;
            dist = Math.min(dist, edge.getDistance(x, y));
        }
        return dist;
    }

    @Override
    public double getDistance(java.awt.geom.Point2D point) {
        return this.getDistance(point.getX(), point.getY());
    }

    @Override
    public Polyline2D transform(AffineTransform2D trans) {
        Point2D[] pts = new Point2D[this.points.size()];
        int i = 0;
        while (i < this.points.size()) {
            pts[i] = trans.transform(this.points.get(i));
            ++i;
        }
        return new Polyline2D(pts);
    }

    @Override
    public boolean contains(double x, double y) {
        for (LineSegment2D edge : this.getEdges()) {
            if (edge.getLength() == 0.0 || !edge.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(java.awt.geom.Point2D point) {
        return this.contains(point.getX(), point.getY());
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        if (this.points.size() < 2) {
            return path;
        }
        Iterator<Point2D> iter = this.points.iterator();
        Point2D point = iter.next();
        while (iter.hasNext()) {
            point = iter.next();
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        return path;
    }

    public GeneralPath getGeneralPath() {
        GeneralPath path = new GeneralPath();
        if (this.points.size() < 2) {
            return path;
        }
        Iterator<Point2D> iter = this.points.iterator();
        Point2D point = iter.next();
        path.moveTo((float)point.getX(), (float)point.getY());
        while (iter.hasNext()) {
            point = iter.next();
            path.lineTo((float)point.getX(), (float)point.getY());
        }
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        g2.draw(this.getGeneralPath());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Polyline2D)) {
            return false;
        }
        Polyline2D polyline = (Polyline2D)obj;
        if (this.points.size() != polyline.points.size()) {
            return false;
        }
        int i = 0;
        while (i < this.points.size()) {
            if (!this.points.get(i).almostEquals(polyline.points.get(i), eps)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Polyline2D)) {
            return false;
        }
        Polyline2D polyline = (Polyline2D)object;
        if (this.points.size() != polyline.points.size()) {
            return false;
        }
        int i = 0;
        while (i < this.points.size()) {
            if (!this.points.get(i).equals(polyline.points.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Polyline2D clone() {
        ArrayList<Point2D> array = new ArrayList<Point2D>(this.points.size());
        for (Point2D point : this.points) {
            array.add(point.clone());
        }
        return new Polyline2D(array);
    }
}

