/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.spline;

import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.Curve2DUtils;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.PolyCurve2D;
import math.geom2d.spline.CubicBezierCurve2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolyCubicBezierCurve2D
extends PolyCurve2D<CubicBezierCurve2D> {
    public static final PolyCubicBezierCurve2D create(Point2D[] points) {
        int np = points.length;
        int nc = (np - 1) / 3;
        PolyCubicBezierCurve2D polyBezier = new PolyCubicBezierCurve2D(nc);
        int i = 0;
        while (i < nc) {
            polyBezier.addCurve(new CubicBezierCurve2D((java.awt.geom.Point2D)points[i * 3], points[i * 3 + 1], (java.awt.geom.Point2D)points[i * 3 + 2], points[i * 3 + 3]));
            ++i;
        }
        return polyBezier;
    }

    public static final PolyCubicBezierCurve2D create(Point2D[] points, Vector2D[] vectors) {
        int np = Math.min(points.length, vectors.length);
        int nc = (np - 1) / 2;
        PolyCubicBezierCurve2D polyBezier = new PolyCubicBezierCurve2D(nc);
        int i = 0;
        while (i < nc) {
            polyBezier.addCurve(new CubicBezierCurve2D((java.awt.geom.Point2D)points[i * 2], vectors[i * 2], (java.awt.geom.Point2D)points[i * 2 + 1], vectors[i * 2 + 1]));
            ++i;
        }
        return polyBezier;
    }

    public PolyCubicBezierCurve2D() {
    }

    public PolyCubicBezierCurve2D(int n) {
        super(n);
    }

    public PolyCubicBezierCurve2D(CubicBezierCurve2D[] curves) {
        super((ContinuousCurve2D[])curves);
    }

    public PolyCubicBezierCurve2D(Collection<CubicBezierCurve2D> curves) {
        super(curves);
    }

    @Override
    public PolyCubicBezierCurve2D clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curve2DUtils.clipCurve(this, box);
        PolyCubicBezierCurve2D result = new PolyCubicBezierCurve2D(set.getCurveNumber());
        for (Curve2D curve2D : set.getCurves()) {
            if (!(curve2D instanceof CubicBezierCurve2D)) continue;
            result.addCurve((CubicBezierCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public PolyCubicBezierCurve2D transform(AffineTransform2D trans) {
        PolyCubicBezierCurve2D result = new PolyCubicBezierCurve2D(this.curves.size());
        for (CubicBezierCurve2D curve : this.curves) {
            result.addCurve(curve.transform(trans));
        }
        return result;
    }
}

