/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.util;

import java.awt.Toolkit;

public class ProjectionUtil {
    private static final double EARTH_RADIUS = 6378137.0;
    private static final double degToRadFactor = Math.PI / 180;
    private static final double ED = 111319.49079327357;
    private static final double PHI_MAX_RAD = Math.asin((Math.exp(Math.PI * 2) - 1.0) / (Math.exp(Math.PI * 2) + 1.0));
    private static final double METERS_PER_PIXEL = 0.02540005 / (double)Toolkit.getDefaultToolkit().getScreenResolution();

    public static double getXGeo(double lon) {
        return lon * 111319.49079327357;
    }

    public static double getLon(double xGeo) {
        return xGeo / 111319.49079327357;
    }

    public static double getYGeo(double lat) {
        double s = Math.sin(lat * (Math.PI / 180));
        return 3189068.5 * Math.log((1.0 + s) / (1.0 - s));
    }

    public static double getLat(double yGeo) {
        return 90.0 * (4.0 * Math.atan(Math.exp(yGeo / 6378137.0)) / Math.PI - 1.0);
    }

    public static int getXPixFromLon(double lon, int zoomLevel) {
        double x = (ProjectionUtil.fit(lon, -180.0, 180.0) + 180.0) / 360.0;
        int s = ProjectionUtil.getTotalMapSizeInPixel(zoomLevel);
        return (int)ProjectionUtil.fit((double)s * x + 0.5, 0.0, s - 1);
    }

    public static double getLonFromXPix(int XPix, int zoomLevel) {
        double s = ProjectionUtil.getTotalMapSizeInPixel(zoomLevel);
        return 360.0 * (ProjectionUtil.fit(XPix, 0.0, s - 1.0) / s - 0.5);
    }

    public static int getYPixFromLat(double lat, int zoomLevel) {
        double sin = Math.sin(ProjectionUtil.fit(lat, -PHI_MAX_RAD, PHI_MAX_RAD) * Math.PI / 180.0);
        double y = 0.5 - Math.log((1.0 + sin) / (1.0 - sin)) / (Math.PI * 4);
        int s = ProjectionUtil.getTotalMapSizeInPixel(zoomLevel);
        return (int)ProjectionUtil.fit((double)s * y + 0.5, 0.0, s - 1);
    }

    public static double getLatFromYPix(int YPix, int zoomLevel) {
        double s = ProjectionUtil.getTotalMapSizeInPixel(zoomLevel);
        double y = 0.5 - ProjectionUtil.fit(YPix, 0.0, s - 1.0) / s;
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * 2.0 * Math.PI)) / Math.PI;
    }

    public static int getXPixFromXGeo(double xGeo, int zoomLevel) {
        return ProjectionUtil.getXPixFromLon(ProjectionUtil.getLon(xGeo), zoomLevel);
    }

    public static double getXGeoFromXPix(int xPix, int zoomLevel) {
        return ProjectionUtil.getXGeo(ProjectionUtil.getLonFromXPix(xPix, zoomLevel));
    }

    public static int getYPixFromYGeo(double yGeo, int zoomLevel) {
        return ProjectionUtil.getYPixFromLat(ProjectionUtil.getLat(yGeo), zoomLevel);
    }

    public static double getYGeoFromYPix(int yPix, int zoomLevel) {
        return ProjectionUtil.getYGeo(ProjectionUtil.getLatFromYPix(yPix, zoomLevel));
    }

    private static double fit(double x, double min, double max) {
        return Math.min(Math.max(x, min), max);
    }

    private static int getTotalMapSizeInPixel(int zoomLevel) {
        return 256 << zoomLevel;
    }

    public static double getPixelSizeEqu(int zoomLevel) {
        return 4.007501668557849E7 / (double)ProjectionUtil.getTotalMapSizeInPixel(zoomLevel);
    }

    public static double getDeformationFactor(double lat) {
        return Math.abs(Math.cos(ProjectionUtil.fit(Math.PI / 180 * lat, -PHI_MAX_RAD, PHI_MAX_RAD)));
    }

    public static double getPixelSize(double lat, int zoomLevel) {
        return ProjectionUtil.getDeformationFactor(lat) * ProjectionUtil.getPixelSizeEqu(zoomLevel);
    }

    public static double getScale(double lat, int zoomLevel) {
        return ProjectionUtil.getPixelSize(lat, zoomLevel) / METERS_PER_PIXEL;
    }
}

