/*
 * Decompiled with CFR 0.152.
 */
package org.opencarto.util;

public class TileUtil {
    public static double getLon(int xTile, int zoom) {
        return (double)xTile / Math.pow(2.0, zoom) * 360.0 - 180.0;
    }

    public static double getLat(int yTile, int zoom) {
        double n = Math.PI - Math.PI * 2 * (double)yTile / Math.pow(2.0, zoom);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static int getXTile(double lon, int zoom) {
        return (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
    }

    public static int getYTile(double lat, int zoom) {
        return (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)(1 << zoom));
    }

    public static int[] getTileXY(int pixelX, int pixelY) {
        return new int[]{pixelX / 256, pixelY / 256};
    }

    public static int[] getTileXYToPixelXY(int tileX, int tileY) {
        return new int[]{tileX * 256, tileY * 256};
    }
}

